/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server;

import com.linkedin.data.DataMap;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.server.ErrorResponseFormat;

public class RestLiServiceException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final HttpStatus _status;
    private Integer _serviceErrorCode;
    private DataMap _errorDetails;
    private ErrorResponseFormat _errorResponseFormat;

    public RestLiServiceException(HttpStatus status) {
        this(status, null, null);
    }

    public RestLiServiceException(HttpStatus status, String message) {
        this(status, message, null);
    }

    public RestLiServiceException(HttpStatus status, Throwable cause) {
        super(cause);
        this._status = status;
    }

    public RestLiServiceException(HttpStatus status, String message, Throwable cause) {
        super(message, cause);
        this._status = status;
    }

    public HttpStatus getStatus() {
        return this._status;
    }

    public RestLiServiceException setServiceErrorCode(Integer serviceErrorCode) {
        this._serviceErrorCode = serviceErrorCode;
        return this;
    }

    public boolean hasServiceErrorCode() {
        return this._serviceErrorCode != null;
    }

    public Integer getServiceErrorCode() {
        return this._serviceErrorCode;
    }

    public DataMap getErrorDetails() {
        return this._errorDetails;
    }

    public boolean hasErrorDetails() {
        return this._errorDetails != null;
    }

    public RestLiServiceException setErrorDetails(DataMap errorDetails) {
        this._errorDetails = errorDetails;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" [HTTP Status:").append(this._status.getCode());
        if (this._serviceErrorCode != null) {
            sb.append(", serviceErrorCode:").append(this._serviceErrorCode);
        }
        sb.append("]");
        String message = this.getLocalizedMessage();
        if (message != null) {
            sb.append(": ").append(message);
        }
        return sb.toString();
    }

    public void setOverridingFormat(ErrorResponseFormat errorResponseFormat) {
        this._errorResponseFormat = errorResponseFormat;
    }

    public boolean hasOverridingErrorResponseFormat() {
        return this._errorResponseFormat != null;
    }

    public ErrorResponseFormat getOverridingFormat() {
        return this._errorResponseFormat;
    }
}

