/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.mock;

import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.server.resources.BeanProvider;
import com.linkedin.restli.server.resources.Jsr330Adapter;
import com.linkedin.restli.server.resources.ResourceFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class InjectMockResourceFactory
implements ResourceFactory {
    private Jsr330Adapter _containerAdaptor;
    private final BeanProvider _beanProvider;

    public InjectMockResourceFactory(BeanProvider beans) {
        this._beanProvider = beans;
    }

    public InjectMockResourceFactory(BeanProvider beans, Class<?> ... resourceClasses) {
        this._beanProvider = beans;
        this._containerAdaptor = new Jsr330Adapter(Arrays.asList(resourceClasses), beans);
    }

    @Override
    public <R> R create(Class<R> resourceClass) {
        return this._containerAdaptor.getBean(resourceClass);
    }

    @Override
    public void setRootResources(Map<String, ResourceModel> rootResources) {
        HashSet allResourceClasses = new HashSet();
        for (ResourceModel resourceModel : rootResources.values()) {
            this.processChildResource(resourceModel, allResourceClasses);
        }
        this._containerAdaptor = new Jsr330Adapter(allResourceClasses, this._beanProvider);
    }

    public void processChildResource(ResourceModel resourceModel, Collection<Class<?>> allResourceClasses) {
        if (resourceModel == null) {
            return;
        }
        allResourceClasses.add(resourceModel.getResourceClass());
        for (ResourceModel child : resourceModel.getSubResources()) {
            this.processChildResource(child, allResourceClasses);
        }
    }
}

