/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.multiplexer;

import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.multiplexer.IndividualRequest;
import com.linkedin.restli.server.multiplexer.IndividualResponseException;
import java.util.Map;
import java.util.Set;

final class RequestSanitizationTask
extends BaseTask<IndividualRequest> {
    private final Set<String> _individualRequestHeaderWhitelist;
    private final IndividualRequest _individualRequest;

    RequestSanitizationTask(IndividualRequest individualRequest, Set<String> individualRequestHeaderWhitelist) {
        this._individualRequestHeaderWhitelist = individualRequestHeaderWhitelist;
        this._individualRequest = individualRequest;
    }

    protected Promise<? extends IndividualRequest> run(Context context) throws Throwable {
        if (this._individualRequest.hasHeaders() && this._individualRequest.getHeaders().size() > 0) {
            for (Map.Entry headerEntry : this._individualRequest.getHeaders().entrySet()) {
                String headerName = (String)headerEntry.getKey();
                if (this._individualRequestHeaderWhitelist.contains(headerName)) continue;
                return Promises.error((Throwable)new IndividualResponseException(HttpStatus.S_400_BAD_REQUEST, String.format("Request header %s is not allowed in the individual request.", headerName)));
            }
        }
        return Promises.value((Object)this._individualRequest);
    }
}

