/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.codec.ArrayType;
import org.apache.qpid.proton.codec.BooleanType;
import org.apache.qpid.proton.codec.ByteBufferDecoder;
import org.apache.qpid.proton.codec.ByteType;
import org.apache.qpid.proton.codec.CharacterType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.apache.qpid.proton.codec.DoubleType;
import org.apache.qpid.proton.codec.DynamicTypeConstructor;
import org.apache.qpid.proton.codec.FloatType;
import org.apache.qpid.proton.codec.IntegerType;
import org.apache.qpid.proton.codec.LongType;
import org.apache.qpid.proton.codec.PrimitiveType;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.ShortType;
import org.apache.qpid.proton.codec.TypeConstructor;

public class DecoderImpl
implements ByteBufferDecoder {
    private ByteBuffer _buffer;
    private PrimitiveTypeEncoding[] _constructors = new PrimitiveTypeEncoding[256];
    private Map<Object, DescribedTypeConstructor> _dynamicTypeConstructors = new HashMap<Object, DescribedTypeConstructor>();

    public DecoderImpl() {
    }

    DecoderImpl(ByteBuffer buffer) {
        this._buffer = buffer;
    }

    TypeConstructor readConstructor() {
        int code = this.readRawByte() & 0xFF;
        if (code == 0) {
            final Object descriptor = this.readObject();
            TypeConstructor nestedEncoding = this.readConstructor();
            DescribedTypeConstructor dtc = this._dynamicTypeConstructors.get(descriptor);
            if (dtc == null) {
                dtc = new DescribedTypeConstructor(){

                    public DescribedType newInstance(Object described) {
                        return new UnknownDescribedType(descriptor, described);
                    }

                    @Override
                    public Class getTypeClass() {
                        return UnknownDescribedType.class;
                    }
                };
                this.register(descriptor, dtc);
            }
            return new DynamicTypeConstructor(dtc, nestedEncoding);
        }
        return this._constructors[code];
    }

    @Override
    public void register(Object descriptor, DescribedTypeConstructor dtc) {
        this._dynamicTypeConstructors.put(descriptor, dtc);
    }

    private ClassCastException unexpectedType(Object val, Class clazz) {
        return new ClassCastException("Unexpected type " + val.getClass().getName() + ". Expected " + clazz.getName() + ".");
    }

    @Override
    public Boolean readBoolean() {
        return this.readBoolean(null);
    }

    @Override
    public Boolean readBoolean(Boolean defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        throw this.unexpectedType(val, Boolean.class);
    }

    @Override
    public boolean readBoolean(boolean defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof BooleanType.BooleanEncoding) {
            return ((BooleanType.BooleanEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Boolean.class);
    }

    @Override
    public Byte readByte() {
        return this.readByte(null);
    }

    @Override
    public Byte readByte(Byte defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Byte) {
            return (Byte)val;
        }
        throw this.unexpectedType(val, Byte.class);
    }

    @Override
    public byte readByte(byte defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof ByteType.ByteEncoding) {
            return ((ByteType.ByteEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Byte.class);
    }

    @Override
    public Short readShort() {
        return this.readShort(null);
    }

    @Override
    public Short readShort(Short defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Short) {
            return (Short)val;
        }
        throw this.unexpectedType(val, Short.class);
    }

    @Override
    public short readShort(short defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof ShortType.ShortEncoding) {
            return ((ShortType.ShortEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Short.class);
    }

    @Override
    public Integer readInteger() {
        return this.readInteger(null);
    }

    @Override
    public Integer readInteger(Integer defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        throw this.unexpectedType(val, Integer.class);
    }

    @Override
    public int readInteger(int defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof IntegerType.IntegerEncoding) {
            return ((IntegerType.IntegerEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Integer.class);
    }

    @Override
    public Long readLong() {
        return this.readLong(null);
    }

    @Override
    public Long readLong(Long defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        throw this.unexpectedType(val, Long.class);
    }

    @Override
    public long readLong(long defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof LongType.LongEncoding) {
            return ((LongType.LongEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Long.class);
    }

    @Override
    public UnsignedByte readUnsignedByte() {
        return this.readUnsignedByte(null);
    }

    @Override
    public UnsignedByte readUnsignedByte(UnsignedByte defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof UnsignedByte) {
            return (UnsignedByte)val;
        }
        throw this.unexpectedType(val, UnsignedByte.class);
    }

    @Override
    public UnsignedShort readUnsignedShort() {
        return this.readUnsignedShort(null);
    }

    @Override
    public UnsignedShort readUnsignedShort(UnsignedShort defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof UnsignedShort) {
            return (UnsignedShort)val;
        }
        throw this.unexpectedType(val, UnsignedShort.class);
    }

    @Override
    public UnsignedInteger readUnsignedInteger() {
        return this.readUnsignedInteger(null);
    }

    @Override
    public UnsignedInteger readUnsignedInteger(UnsignedInteger defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof UnsignedInteger) {
            return (UnsignedInteger)val;
        }
        throw this.unexpectedType(val, UnsignedInteger.class);
    }

    @Override
    public UnsignedLong readUnsignedLong() {
        return this.readUnsignedLong(null);
    }

    @Override
    public UnsignedLong readUnsignedLong(UnsignedLong defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof UnsignedLong) {
            return (UnsignedLong)val;
        }
        throw this.unexpectedType(val, UnsignedLong.class);
    }

    @Override
    public Character readCharacter() {
        return this.readCharacter(null);
    }

    @Override
    public Character readCharacter(Character defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Character) {
            return (Character)val;
        }
        throw this.unexpectedType(val, Character.class);
    }

    @Override
    public char readCharacter(char defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof CharacterType.CharacterEncoding) {
            return ((CharacterType.CharacterEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Character.class);
    }

    @Override
    public Float readFloat() {
        return this.readFloat(null);
    }

    @Override
    public Float readFloat(Float defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Float) {
            return (Float)val;
        }
        throw this.unexpectedType(val, Float.class);
    }

    @Override
    public float readFloat(float defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof FloatType.FloatEncoding) {
            return ((FloatType.FloatEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Float.class);
    }

    @Override
    public Double readDouble() {
        return this.readDouble(null);
    }

    @Override
    public Double readDouble(Double defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        throw this.unexpectedType(val, Double.class);
    }

    @Override
    public double readDouble(double defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        if (constructor instanceof DoubleType.DoubleEncoding) {
            return ((DoubleType.DoubleEncoding)constructor).readPrimitiveValue();
        }
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        throw this.unexpectedType(val, Double.class);
    }

    @Override
    public UUID readUUID() {
        return this.readUUID(null);
    }

    @Override
    public UUID readUUID(UUID defaultVal) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof UUID) {
            return (UUID)val;
        }
        throw this.unexpectedType(val, UUID.class);
    }

    @Override
    public Decimal32 readDecimal32() {
        return this.readDecimal32(null);
    }

    @Override
    public Decimal32 readDecimal32(Decimal32 defaultValue) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Decimal32) {
            return (Decimal32)val;
        }
        throw this.unexpectedType(val, Decimal32.class);
    }

    @Override
    public Decimal64 readDecimal64() {
        return this.readDecimal64(null);
    }

    @Override
    public Decimal64 readDecimal64(Decimal64 defaultValue) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Decimal64) {
            return (Decimal64)val;
        }
        throw this.unexpectedType(val, Decimal64.class);
    }

    @Override
    public Decimal128 readDecimal128() {
        return this.readDecimal128(null);
    }

    @Override
    public Decimal128 readDecimal128(Decimal128 defaultValue) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Decimal128) {
            return (Decimal128)val;
        }
        throw this.unexpectedType(val, Decimal128.class);
    }

    @Override
    public Date readTimestamp() {
        return this.readTimestamp(null);
    }

    @Override
    public Date readTimestamp(Date defaultValue) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Date) {
            return (Date)val;
        }
        throw this.unexpectedType(val, Date.class);
    }

    @Override
    public Binary readBinary() {
        return this.readBinary(null);
    }

    @Override
    public Binary readBinary(Binary defaultValue) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Binary) {
            return (Binary)val;
        }
        throw this.unexpectedType(val, Binary.class);
    }

    @Override
    public Symbol readSymbol() {
        return this.readSymbol(null);
    }

    @Override
    public Symbol readSymbol(Symbol defaultValue) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Symbol) {
            return (Symbol)val;
        }
        throw this.unexpectedType(val, Symbol.class);
    }

    @Override
    public String readString() {
        return this.readString(null);
    }

    @Override
    public String readString(String defaultValue) {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof String) {
            return (String)val;
        }
        throw this.unexpectedType(val, String.class);
    }

    @Override
    public List readList() {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return null;
        }
        if (val instanceof List) {
            return (List)val;
        }
        throw this.unexpectedType(val, List.class);
    }

    @Override
    public <T> void readList(Decoder.ListProcessor<T> processor) {
    }

    @Override
    public Map readMap() {
        TypeConstructor constructor = this.readConstructor();
        Object val = constructor.readValue();
        if (val == null) {
            return null;
        }
        if (val instanceof Map) {
            return (Map)val;
        }
        throw this.unexpectedType(val, Map.class);
    }

    @Override
    public <T> T[] readArray(Class<T> clazz) {
        return null;
    }

    @Override
    public Object[] readArray() {
        return (Object[])this.readConstructor().readValue();
    }

    @Override
    public boolean[] readBooleanArray() {
        return (boolean[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public byte[] readByteArray() {
        return (byte[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public short[] readShortArray() {
        return (short[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public int[] readIntegerArray() {
        return (int[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public long[] readLongArray() {
        return (long[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public float[] readFloatArray() {
        return (float[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public double[] readDoubleArray() {
        return (double[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public char[] readCharacterArray() {
        return (char[])((ArrayType.ArrayEncoding)this.readConstructor()).readValueArray();
    }

    @Override
    public <T> T[] readMultiple(Class<T> clazz) {
        Object val = this.readObject();
        if (val == null) {
            return null;
        }
        if (val.getClass().isArray()) {
            if (clazz.isAssignableFrom(val.getClass().getComponentType())) {
                return (Object[])val;
            }
            throw this.unexpectedType(val, Array.newInstance(clazz, 0).getClass());
        }
        if (clazz.isAssignableFrom(val.getClass())) {
            Object[] array = (Object[])Array.newInstance(clazz, 1);
            array[0] = val;
            return array;
        }
        throw this.unexpectedType(val, Array.newInstance(clazz, 0).getClass());
    }

    @Override
    public Object[] readMultiple() {
        Object val = this.readObject();
        if (val == null) {
            return null;
        }
        if (val.getClass().isArray()) {
            return (Object[])val;
        }
        Object[] array = (Object[])Array.newInstance(val.getClass(), 1);
        array[0] = val;
        return array;
    }

    @Override
    public byte[] readByteMultiple() {
        return new byte[0];
    }

    @Override
    public short[] readShortMultiple() {
        return new short[0];
    }

    @Override
    public int[] readIntegerMultiple() {
        return new int[0];
    }

    @Override
    public long[] readLongMultiple() {
        return new long[0];
    }

    @Override
    public float[] readFloatMultiple() {
        return new float[0];
    }

    @Override
    public double[] readDoubleMultiple() {
        return new double[0];
    }

    @Override
    public char[] readCharacterMultiple() {
        return new char[0];
    }

    @Override
    public Object readObject() {
        TypeConstructor constructor = this.readConstructor();
        if (constructor == null) {
            throw new DecodeException("Unknown constructor");
        }
        return constructor instanceof ArrayType.ArrayEncoding ? ((ArrayType.ArrayEncoding)constructor).readValueArray() : constructor.readValue();
    }

    @Override
    public Object readObject(Object defaultValue) {
        Object val = this.readObject();
        return val == null ? defaultValue : val;
    }

    <V> void register(PrimitiveType<V> type) {
        Collection<PrimitiveTypeEncoding<V>> encodings = type.getAllEncodings();
        Iterator<PrimitiveTypeEncoding<V>> iterator = encodings.iterator();
        while (iterator.hasNext()) {
            PrimitiveTypeEncoding<V> encoding;
            this._constructors[encoding.getEncodingCode() & 0xFF] = encoding = iterator.next();
        }
    }

    byte readRawByte() {
        return this._buffer.get();
    }

    int readRawInt() {
        return this._buffer.getInt();
    }

    long readRawLong() {
        return this._buffer.getLong();
    }

    short readRawShort() {
        return this._buffer.getShort();
    }

    float readRawFloat() {
        return this._buffer.getFloat();
    }

    double readRawDouble() {
        return this._buffer.getDouble();
    }

    void readRaw(byte[] data, int offset, int length) {
        this._buffer.get(data, offset, length);
    }

    <V> V readRaw(TypeDecoder<V> decoder, int size) {
        V decode = decoder.decode((ByteBuffer)this._buffer.slice().limit(size));
        this._buffer.position(this._buffer.position() + size);
        return decode;
    }

    @Override
    public void setByteBuffer(ByteBuffer buffer) {
        this._buffer = buffer;
    }

    @Override
    public int getByteBufferRemaining() {
        return this._buffer.remaining();
    }

    private static class UnknownDescribedType
    implements DescribedType {
        private final Object _descriptor;
        private final Object _described;

        public UnknownDescribedType(Object descriptor, Object described) {
            this._descriptor = descriptor;
            this._described = described;
        }

        @Override
        public Object getDescriptor() {
            return this._descriptor;
        }

        @Override
        public Object getDescribed() {
            return this._described;
        }

        public boolean equals(Object obj) {
            return obj instanceof DescribedType && this._descriptor == null ? ((DescribedType)obj).getDescriptor() == null : (this._descriptor.equals(((DescribedType)obj).getDescriptor()) && this._described == null ? ((DescribedType)obj).getDescribed() == null : this._described.equals(((DescribedType)obj).getDescribed()));
        }
    }

    static interface TypeDecoder<V> {
        public V decode(ByteBuffer var1);
    }
}

