/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.multipart;

import com.linkedin.data.ByteString;
import com.linkedin.multipart.MultiPartMIMEDataSourceIterator;
import com.linkedin.multipart.MultiPartMIMEDataSourceIteratorCallback;
import com.linkedin.multipart.MultiPartMIMEDataSourceWriter;
import com.linkedin.multipart.MultiPartMIMEReaderCallback;
import com.linkedin.multipart.MultiPartMIMEUtils;
import com.linkedin.multipart.SinglePartMIMEChainReaderCallback;
import com.linkedin.multipart.SinglePartMIMEReaderCallback;
import com.linkedin.multipart.exceptions.MultiPartIllegalFormatException;
import com.linkedin.multipart.exceptions.MultiPartReaderFinishedException;
import com.linkedin.multipart.exceptions.SinglePartBindException;
import com.linkedin.multipart.exceptions.SinglePartFinishedException;
import com.linkedin.multipart.exceptions.SinglePartNotInitializedException;
import com.linkedin.multipart.exceptions.StreamBusyException;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.ReadHandle;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.r2.util.LinkedDeque;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.Callable;

public class MultiPartMIMEReader
implements MultiPartMIMEDataSourceIterator {
    private final R2MultiPartMIMEReader _reader;
    private final EntityStream _entityStream;
    private volatile MultiPartMIMEReaderCallback _clientCallback;
    private volatile String _preamble;
    private volatile MultiPartReaderState _multiPartReaderState;
    private volatile SinglePartMIMEReader _currentSinglePartMIMEReader;

    public static MultiPartMIMEReader createAndAcquireStream(StreamRequest request, MultiPartMIMEReaderCallback clientCallback) throws MultiPartIllegalFormatException {
        return new MultiPartMIMEReader(request, clientCallback);
    }

    public static MultiPartMIMEReader createAndAcquireStream(StreamResponse response, MultiPartMIMEReaderCallback clientCallback) throws MultiPartIllegalFormatException {
        return new MultiPartMIMEReader(response, clientCallback);
    }

    public static MultiPartMIMEReader createAndAcquireStream(StreamRequest request) throws MultiPartIllegalFormatException {
        return new MultiPartMIMEReader(request, null);
    }

    public static MultiPartMIMEReader createAndAcquireStream(StreamResponse response) throws MultiPartIllegalFormatException {
        return new MultiPartMIMEReader(response, null);
    }

    private MultiPartMIMEReader(StreamRequest request, MultiPartMIMEReaderCallback clientCallback) throws MultiPartIllegalFormatException {
        String contentTypeHeaderValue = request.getHeader("Content-Type");
        if (contentTypeHeaderValue == null) {
            throw new MultiPartIllegalFormatException("Malformed multipart mime request. No Content-Type header in this request");
        }
        this._reader = new R2MultiPartMIMEReader(MultiPartMIMEUtils.extractBoundary(contentTypeHeaderValue));
        this._entityStream = request.getEntityStream();
        this._multiPartReaderState = MultiPartReaderState.CREATED;
        if (clientCallback != null) {
            this._clientCallback = clientCallback;
            this._entityStream.setReader((Reader)this._reader);
        }
    }

    private MultiPartMIMEReader(StreamResponse response, MultiPartMIMEReaderCallback clientCallback) throws MultiPartIllegalFormatException {
        String contentTypeHeaderValue = response.getHeader("Content-Type");
        if (contentTypeHeaderValue == null) {
            throw new MultiPartIllegalFormatException("Malformed multipart mime request. No Content-Type header in this response");
        }
        this._reader = new R2MultiPartMIMEReader(MultiPartMIMEUtils.extractBoundary(contentTypeHeaderValue));
        this._entityStream = response.getEntityStream();
        this._multiPartReaderState = MultiPartReaderState.CREATED;
        if (clientCallback != null) {
            this._clientCallback = clientCallback;
            this._entityStream.setReader((Reader)this._reader);
        }
    }

    public boolean haveAllPartsFinished() {
        return this._multiPartReaderState == MultiPartReaderState.FINISHED;
    }

    public void drainAllParts() {
        if (this._multiPartReaderState == MultiPartReaderState.FINISHED || this._multiPartReaderState == MultiPartReaderState.READING_EPILOGUE) {
            throw new MultiPartReaderFinishedException("The reader is finished therefore it cannot proceed.");
        }
        if (this._multiPartReaderState == MultiPartReaderState.CALLBACK_BOUND_AND_READING_PREAMBLE) {
            throw new StreamBusyException("The reader is busy processing the preamble. Unable to proceed with draining. Please only call drainAllParts() upon invocation of onNewPart() on the client callback.");
        }
        if (this._multiPartReaderState == MultiPartReaderState.DRAINING) {
            throw new StreamBusyException("Reader already busy draining.");
        }
        if (this._multiPartReaderState == MultiPartReaderState.CREATED) {
            this._multiPartReaderState = MultiPartReaderState.FINISHED;
            this._entityStream.setReader((Reader)this._reader);
            return;
        }
        assert (this._multiPartReaderState == MultiPartReaderState.READING_PARTS);
        if (this._currentSinglePartMIMEReader._singleReaderState != SingleReaderState.CREATED) {
            throw new StreamBusyException("Unable to drain all parts due to current SinglePartMIMEReader in use.");
        }
        this._currentSinglePartMIMEReader._singleReaderState = SingleReaderState.FINISHED;
        this._multiPartReaderState = MultiPartReaderState.DRAINING;
        this._reader.processEventAndInvokeClient();
    }

    public void registerReaderCallback(MultiPartMIMEReaderCallback clientCallback) {
        if (this._multiPartReaderState == MultiPartReaderState.FINISHED || this._multiPartReaderState == MultiPartReaderState.READING_EPILOGUE) {
            throw new MultiPartReaderFinishedException("Unable to register a callback. This reader has already finished reading.");
        }
        if (this._multiPartReaderState == MultiPartReaderState.CALLBACK_BOUND_AND_READING_PREAMBLE) {
            throw new StreamBusyException("Reader is busy reading in the preamble. Unable to register the callback at this time.");
        }
        if (this._multiPartReaderState == MultiPartReaderState.DRAINING) {
            throw new StreamBusyException("Reader is busy performing a complete draining. Unable to register the callback.");
        }
        if (this._currentSinglePartMIMEReader != null && this._currentSinglePartMIMEReader._singleReaderState != SingleReaderState.CREATED) {
            throw new StreamBusyException("Unable to register callback on the reader since there is currently a SinglePartMIMEReader in use, meaning that it was registered with a SinglePartMIMEReaderCallback.");
        }
        if (this._clientCallback == null) {
            this._multiPartReaderState = MultiPartReaderState.CALLBACK_BOUND_AND_READING_PREAMBLE;
            this._clientCallback = clientCallback;
            this._entityStream.setReader((Reader)this._reader);
            return;
        }
        this._clientCallback = clientCallback;
        if (this._currentSinglePartMIMEReader != null) {
            try {
                this._clientCallback.onNewPart(this._currentSinglePartMIMEReader);
            }
            catch (RuntimeException exception) {
                this._reader.handleExceptions(exception);
            }
        }
    }

    R2MultiPartMIMEReader getR2MultiPartMIMEReader() {
        return this._reader;
    }

    void setState(MultiPartReaderState multiPartReaderState) {
        this._multiPartReaderState = multiPartReaderState;
    }

    void setCurrentSinglePartMIMEReader(SinglePartMIMEReader singlePartMIMEReader) {
        this._currentSinglePartMIMEReader = singlePartMIMEReader;
    }

    @Override
    public void abandonAllDataSources() {
        this.drainAllParts();
    }

    @Override
    public void registerDataSourceReaderCallback(final MultiPartMIMEDataSourceIteratorCallback callback) {
        this.registerReaderCallback(new MultiPartMIMEReaderCallback(){

            @Override
            public void onNewPart(SinglePartMIMEReader singlePartMIMEReader) {
                callback.onNewDataSource(singlePartMIMEReader);
            }

            @Override
            public void onFinished() {
                callback.onFinished();
            }

            @Override
            public void onDrainComplete() {
                callback.onAbandonComplete();
            }

            @Override
            public void onStreamError(Throwable throwable) {
                callback.onStreamError(throwable);
            }
        });
    }

    static enum SingleReaderState {
        CREATED,
        CALLBACK_BOUND_AND_READY,
        REQUESTED_DATA,
        REQUESTED_DRAIN,
        FINISHED;

    }

    public class SinglePartMIMEReader
    implements MultiPartMIMEDataSourceWriter {
        private final Map<String, String> _headers;
        private volatile SinglePartMIMEReaderCallback _callback = null;
        private final R2MultiPartMIMEReader _r2MultiPartMIMEReader;
        private volatile SingleReaderState _singleReaderState = SingleReaderState.CREATED;

        SinglePartMIMEReader(Map<String, String> headers) {
            this._r2MultiPartMIMEReader = MultiPartMIMEReader.this._reader;
            this._headers = Collections.unmodifiableMap(headers);
        }

        public void registerReaderCallback(SinglePartMIMEReaderCallback callback) {
            if (this._singleReaderState != SingleReaderState.CREATED) {
                throw new SinglePartBindException("Callback already registered.");
            }
            this._singleReaderState = SingleReaderState.CALLBACK_BOUND_AND_READY;
            this._callback = callback;
        }

        public void requestPartData() {
            this.verifyUsableState();
            if (this._singleReaderState == SingleReaderState.CREATED) {
                throw new SinglePartNotInitializedException("This SinglePartMIMEReader has not had a callback registered with it yet.");
            }
            this._singleReaderState = SingleReaderState.REQUESTED_DATA;
            this._r2MultiPartMIMEReader.processEventAndInvokeClient();
        }

        public void drainPart() {
            this.verifyUsableState();
            this._singleReaderState = SingleReaderState.REQUESTED_DRAIN;
            this._r2MultiPartMIMEReader.processEventAndInvokeClient();
        }

        void verifyUsableState() {
            if (this._singleReaderState == SingleReaderState.FINISHED) {
                throw new SinglePartFinishedException("This SinglePartMIMEReader has already finished.");
            }
            if (this._singleReaderState == SingleReaderState.REQUESTED_DATA) {
                throw new StreamBusyException("This SinglePartMIMEReader is currently busy fulfilling a call to requestPartData().");
            }
            if (this._singleReaderState == SingleReaderState.REQUESTED_DRAIN) {
                throw new StreamBusyException("This SinglePartMIMEReader is currently busy fulfilling a call to drainPart().");
            }
        }

        void setState(SingleReaderState singleReaderState) {
            this._singleReaderState = singleReaderState;
        }

        @Override
        public Map<String, String> dataSourceHeaders() {
            return this._headers;
        }

        public void onInit(WriteHandle writeHandle) {
            SinglePartMIMEChainReaderCallback singlePartMIMEChainReaderCallback = new SinglePartMIMEChainReaderCallback(writeHandle, this);
            this.registerReaderCallback(singlePartMIMEChainReaderCallback);
        }

        public void onWritePossible() {
            this.requestPartData();
        }

        public void onAbort(Throwable e) {
            this.drainPart();
        }
    }

    private static final class OnPartDataCallable
    implements Callable<Void> {
        private final SinglePartMIMEReaderCallback _singlePartMIMEReaderCallback;
        private final ByteString _data;

        @Override
        public Void call() throws Exception {
            this._singlePartMIMEReaderCallback.onPartDataAvailable(this._data);
            return null;
        }

        OnPartDataCallable(SinglePartMIMEReaderCallback singlePartMIMEReaderCallback, ByteString data) {
            this._singlePartMIMEReaderCallback = singlePartMIMEReaderCallback;
            this._data = data;
        }
    }

    private static final class RecursiveCallable
    implements Callable<Void> {
        private final R2MultiPartMIMEReader _r2MultiPartMIMEReader;

        @Override
        public Void call() throws Exception {
            this._r2MultiPartMIMEReader.onDataAvailable(ByteString.empty());
            return null;
        }

        RecursiveCallable(R2MultiPartMIMEReader r2MultiPartMIMEReader) {
            this._r2MultiPartMIMEReader = r2MultiPartMIMEReader;
        }
    }

    private static final class OnNewPartCallable
    implements Callable<Void> {
        private final MultiPartMIMEReaderCallback _multiPartMIMEReaderCallback;
        private final SinglePartMIMEReader _singlePartMIMEReader;

        @Override
        public Void call() throws Exception {
            this._multiPartMIMEReaderCallback.onNewPart(this._singlePartMIMEReader);
            return null;
        }

        OnNewPartCallable(MultiPartMIMEReaderCallback multiPartMIMEReaderCallback, SinglePartMIMEReader singlePartMIMEReader) {
            this._multiPartMIMEReaderCallback = multiPartMIMEReaderCallback;
            this._singlePartMIMEReader = singlePartMIMEReader;
        }
    }

    static enum MultiPartReaderState {
        CREATED,
        CALLBACK_BOUND_AND_READING_PREAMBLE,
        READING_PARTS,
        READING_EPILOGUE,
        DRAINING,
        FINISHED;

    }

    class R2MultiPartMIMEReader
    implements Reader {
        private volatile ReadHandle _rh;
        private volatile ByteString _compoundByteStringBuffer = ByteString.empty();
        private final String _firstBoundary;
        private final String _normalBoundary;
        private final String _finishingBoundary;
        private byte[] _firstBoundaryBytes;
        private byte[] _normalBoundaryBytes;
        private byte[] _finishingBoundaryBytes;
        private volatile boolean _firstBoundaryEvaluated = false;
        private volatile boolean _r2Done = false;
        private final Queue<Callable<Void>> _callbackQueue = new LinkedDeque();
        private volatile boolean _callbackInProgress = false;

        public void onInit(ReadHandle rh) {
            if (MultiPartMIMEReader.this._multiPartReaderState == MultiPartReaderState.FINISHED) {
                rh.cancel();
                return;
            }
            this._rh = rh;
            this._rh.request(1);
        }

        public void onDataAvailable(ByteString data) {
            this.processEventAndInvokeClient(data);
        }

        public void onDone() {
            this._r2Done = true;
            this.processEventAndInvokeClient();
        }

        public void onError(Throwable e) {
            if (MultiPartMIMEReader.this._multiPartReaderState == MultiPartReaderState.FINISHED) {
                return;
            }
            this.handleExceptions(e);
        }

        private void processEventAndInvokeClient() {
            this.processEventAndInvokeClient(ByteString.empty());
        }

        private void processEventAndInvokeClient(ByteString data) {
            if (this.checkAndProcessEpilogue()) {
                return;
            }
            if (this.checkAndProcessTopLevelDraining()) {
                return;
            }
            this._compoundByteStringBuffer = new ByteString.Builder().append(this._compoundByteStringBuffer).append(data).build();
            if (this.checkAndProcessPreamble()) {
                return;
            }
            this.performPartReading();
        }

        private void processAndInvokeCallableQueue() {
            this._callbackInProgress = true;
            while (!this._callbackQueue.isEmpty()) {
                Callable<Void> callable = this._callbackQueue.poll();
                try {
                    callable.call();
                }
                catch (Throwable clientCallbackException) {
                    this.handleExceptions(clientCallbackException);
                }
            }
            this._callbackInProgress = false;
        }

        private boolean checkAndProcessEpilogue() {
            if (MultiPartMIMEReader.this._multiPartReaderState == MultiPartReaderState.READING_EPILOGUE) {
                if (this._r2Done) {
                    MultiPartMIMEReader.this._multiPartReaderState = MultiPartReaderState.FINISHED;
                    try {
                        MultiPartMIMEReader.this._clientCallback.onFinished();
                    }
                    catch (RuntimeException clientCallbackException) {
                        this.handleExceptions(clientCallbackException);
                    }
                    return true;
                }
                this._rh.request(1);
                return true;
            }
            return false;
        }

        private boolean checkAndProcessTopLevelDraining() {
            if (MultiPartMIMEReader.this._multiPartReaderState == MultiPartReaderState.DRAINING) {
                if (this._r2Done) {
                    MultiPartMIMEReader.this._multiPartReaderState = MultiPartReaderState.FINISHED;
                    try {
                        MultiPartMIMEReader.this._clientCallback.onDrainComplete();
                    }
                    catch (RuntimeException clientCallbackException) {
                        this.handleExceptions(clientCallbackException);
                    }
                    return true;
                }
                this._rh.request(1);
                return true;
            }
            return false;
        }

        private boolean checkAndProcessPreamble() {
            if (MultiPartMIMEReader.this._multiPartReaderState == MultiPartReaderState.CALLBACK_BOUND_AND_READING_PREAMBLE) {
                int lastBoundaryLookup;
                int firstBoundaryLookup = this._compoundByteStringBuffer.indexOfBytes(this._firstBoundaryBytes);
                if (firstBoundaryLookup - MultiPartMIMEUtils.CRLF_BYTES.length == (lastBoundaryLookup = this._compoundByteStringBuffer.indexOfBytes(this._finishingBoundaryBytes))) {
                    MultiPartMIMEReader.this._multiPartReaderState = MultiPartReaderState.FINISHED;
                    try {
                        MultiPartMIMEReader.this._clientCallback.onFinished();
                    }
                    catch (RuntimeException clientCallbackException) {
                        this.handleExceptions(clientCallbackException);
                    }
                    return true;
                }
                if (firstBoundaryLookup > -1) {
                    ByteString preambleSlice = this._compoundByteStringBuffer.slice(0, firstBoundaryLookup);
                    MultiPartMIMEReader.this._preamble = preambleSlice.asString(Charset.defaultCharset());
                    this._compoundByteStringBuffer = this._compoundByteStringBuffer.slice(firstBoundaryLookup, this._compoundByteStringBuffer.length() - firstBoundaryLookup);
                    MultiPartMIMEReader.this._multiPartReaderState = MultiPartReaderState.READING_PARTS;
                } else {
                    if (this._r2Done) {
                        this.handleExceptions(new MultiPartIllegalFormatException("Malformed multipart mime request. No boundary found!"));
                        return true;
                    }
                    this._rh.request(1);
                    return true;
                }
            }
            return false;
        }

        private boolean checkForSufficientBufferSize() {
            if (this._compoundByteStringBuffer.length() < this._finishingBoundaryBytes.length) {
                if (this._r2Done) {
                    this.handleExceptions(new MultiPartIllegalFormatException("Malformed multipart mime request. Finishing boundary missing!"));
                    return true;
                }
                this._rh.request(1);
                return true;
            }
            return false;
        }

        private void performPartReading() {
            int boundarySize;
            int boundaryIndex;
            if (this.checkForSufficientBufferSize()) {
                return;
            }
            assert (MultiPartMIMEReader.this._multiPartReaderState == MultiPartReaderState.READING_PARTS);
            if (!this._firstBoundaryEvaluated) {
                boundaryIndex = this._compoundByteStringBuffer.indexOfBytes(this._firstBoundaryBytes);
                boundarySize = this._firstBoundaryBytes.length;
            } else {
                boundaryIndex = this._compoundByteStringBuffer.indexOfBytes(this._normalBoundaryBytes);
                boundarySize = this._normalBoundaryBytes.length;
            }
            if (boundaryIndex != 0) {
                this.processBufferStartingWithoutBoundary(boundaryIndex);
            } else {
                this.processBufferStartingWithBoundary(boundarySize);
            }
        }

        private void processBufferStartingWithoutBoundary(int boundaryIndex) {
            assert (MultiPartMIMEReader.this._currentSinglePartMIMEReader != null);
            SingleReaderState currentState = MultiPartMIMEReader.this._currentSinglePartMIMEReader._singleReaderState;
            assert (currentState == SingleReaderState.REQUESTED_DATA || currentState == SingleReaderState.REQUESTED_DRAIN);
            if (boundaryIndex == -1) {
                this.processBufferNotContainingBoundary(currentState);
            } else {
                this.processBufferContainingBoundary(boundaryIndex, currentState);
            }
        }

        private void processBufferNotContainingBoundary(SingleReaderState singleReaderState) {
            int amountToLeaveBehind = this._normalBoundaryBytes.length - 1;
            int maxAmountAvailableForClient = this._compoundByteStringBuffer.length() - amountToLeaveBehind;
            ByteString clientData = this.decomposeClientDataAndUpdateBuffer(maxAmountAvailableForClient);
            if (singleReaderState == SingleReaderState.REQUESTED_DATA) {
                MultiPartMIMEReader.this._currentSinglePartMIMEReader._singleReaderState = SingleReaderState.CALLBACK_BOUND_AND_READY;
                OnPartDataCallable onPartDataAvailableInvocation = new OnPartDataCallable(MultiPartMIMEReader.this._currentSinglePartMIMEReader._callback, clientData);
                this._callbackQueue.add(onPartDataAvailableInvocation);
                if (this._callbackInProgress) {
                    return;
                }
                this.processAndInvokeCallableQueue();
            } else {
                RecursiveCallable recursiveCallable = new RecursiveCallable(this);
                this._callbackQueue.add(recursiveCallable);
                if (this._callbackInProgress) {
                    return;
                }
                this.processAndInvokeCallableQueue();
            }
        }

        private void processBufferContainingBoundary(int boundaryIndex, SingleReaderState singleReaderState) {
            int maxAmountAvailableForClient = boundaryIndex;
            ByteString clientData = this.decomposeClientDataAndUpdateBuffer(maxAmountAvailableForClient);
            if (singleReaderState == SingleReaderState.REQUESTED_DATA) {
                MultiPartMIMEReader.this._currentSinglePartMIMEReader._singleReaderState = SingleReaderState.CALLBACK_BOUND_AND_READY;
                OnPartDataCallable onPartDataAvailableInvocation = new OnPartDataCallable(MultiPartMIMEReader.this._currentSinglePartMIMEReader._callback, clientData);
                this._callbackQueue.add(onPartDataAvailableInvocation);
                if (this._callbackInProgress) {
                    return;
                }
                this.processAndInvokeCallableQueue();
            } else {
                RecursiveCallable recursiveCallable = new RecursiveCallable(this);
                this._callbackQueue.add(recursiveCallable);
                if (this._callbackInProgress) {
                    return;
                }
                this.processAndInvokeCallableQueue();
            }
        }

        private ByteString decomposeClientDataAndUpdateBuffer(int maxAmountAvailableForClient) {
            List decomposedByteStrings = this._compoundByteStringBuffer.decompose();
            ByteString firstNonEmptyByteString = null;
            for (int i = 0; i < decomposedByteStrings.size(); ++i) {
                if (((ByteString)decomposedByteStrings.get(i)).length() <= 0) continue;
                firstNonEmptyByteString = (ByteString)decomposedByteStrings.get(i);
                break;
            }
            assert (firstNonEmptyByteString != null);
            ByteString clientData = firstNonEmptyByteString.length() <= maxAmountAvailableForClient ? firstNonEmptyByteString : firstNonEmptyByteString.slice(0, maxAmountAvailableForClient);
            this._compoundByteStringBuffer = this._compoundByteStringBuffer.slice(clientData.length(), this._compoundByteStringBuffer.length() - clientData.length());
            return clientData;
        }

        private void processBufferStartingWithBoundary(int boundarySize) {
            if (this.finishCurrentPart()) {
                return;
            }
            if (this._compoundByteStringBuffer.startsWith(this._finishingBoundaryBytes)) {
                MultiPartMIMEReader.this._multiPartReaderState = MultiPartReaderState.READING_EPILOGUE;
                if (this._r2Done) {
                    MultiPartMIMEReader.this._multiPartReaderState = MultiPartReaderState.FINISHED;
                    try {
                        MultiPartMIMEReader.this._clientCallback.onFinished();
                    }
                    catch (RuntimeException clientCallbackException) {
                        this.handleExceptions(clientCallbackException);
                    }
                    return;
                }
                this._rh.request(1);
                return;
            }
            this.processNewPart(boundarySize);
        }

        private boolean finishCurrentPart() {
            if (MultiPartMIMEReader.this._currentSinglePartMIMEReader != null) {
                if (MultiPartMIMEReader.this._currentSinglePartMIMEReader._singleReaderState == SingleReaderState.REQUESTED_DRAIN) {
                    if (MultiPartMIMEReader.this._currentSinglePartMIMEReader._callback != null) {
                        MultiPartMIMEReader.this._currentSinglePartMIMEReader._singleReaderState = SingleReaderState.FINISHED;
                        try {
                            MultiPartMIMEReader.this._currentSinglePartMIMEReader._callback.onDrainComplete();
                        }
                        catch (RuntimeException clientCallbackException) {
                            this.handleExceptions(clientCallbackException);
                            return true;
                        }
                    }
                } else {
                    MultiPartMIMEReader.this._currentSinglePartMIMEReader._singleReaderState = SingleReaderState.FINISHED;
                    try {
                        MultiPartMIMEReader.this._currentSinglePartMIMEReader._callback.onFinished();
                    }
                    catch (RuntimeException clientCallbackException) {
                        this.handleExceptions(clientCallbackException);
                        return true;
                    }
                }
                MultiPartMIMEReader.this._currentSinglePartMIMEReader = null;
            }
            return false;
        }

        private void processNewPart(int boundarySize) {
            if (boundarySize + MultiPartMIMEUtils.CONSECUTIVE_CRLFS_BYTES.length > this._compoundByteStringBuffer.length()) {
                if (this._r2Done) {
                    this.handleExceptions(new MultiPartIllegalFormatException("Malformed multipart mime request. Premature termination of multipart mime body due to a boundary without a subsequent consecutive CRLF."));
                    return;
                }
                this._rh.request(1);
                return;
            }
            ByteString possibleHeaderArea = this._compoundByteStringBuffer.slice(boundarySize, this._compoundByteStringBuffer.length() - boundarySize);
            int headerEnding = possibleHeaderArea.indexOfBytes(MultiPartMIMEUtils.CONSECUTIVE_CRLFS_BYTES);
            if (headerEnding == -1) {
                if (this._r2Done) {
                    this.handleExceptions(new MultiPartIllegalFormatException("Malformed multipart mime request. Premature termination of headers within a part."));
                    return;
                }
                this._rh.request(1);
                return;
            }
            ByteString headerBytesSlice = possibleHeaderArea.slice(0, headerEnding + MultiPartMIMEUtils.CONSECUTIVE_CRLFS_BYTES.length);
            Map<String, String> headers = this.parseHeaders(headerBytesSlice);
            if (headers == null) {
                return;
            }
            int consumedDataIndex = boundarySize + headerEnding + MultiPartMIMEUtils.CONSECUTIVE_CRLFS_BYTES.length;
            this._compoundByteStringBuffer = this._compoundByteStringBuffer.slice(consumedDataIndex, this._compoundByteStringBuffer.length() - consumedDataIndex);
            MultiPartMIMEReader.this._currentSinglePartMIMEReader = new SinglePartMIMEReader(headers);
            OnNewPartCallable onNewPartInvocation = new OnNewPartCallable(MultiPartMIMEReader.this._clientCallback, MultiPartMIMEReader.this._currentSinglePartMIMEReader);
            this._callbackQueue.add(onNewPartInvocation);
            this._firstBoundaryEvaluated = true;
            if (this._callbackInProgress) {
                return;
            }
            this.processAndInvokeCallableQueue();
        }

        private Map<String, String> parseHeaders(ByteString headerBytes) {
            Map<String, String> headers;
            if (headerBytes.equals((Object)MultiPartMIMEUtils.BYTE_STRING_CONSECUTIVE_CRLFS_BYTES)) {
                headers = Collections.emptyMap();
            } else {
                headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                ByteString leadingBytes = headerBytes.slice(0, MultiPartMIMEUtils.CRLF_BYTES.length);
                if (!leadingBytes.equals((Object)MultiPartMIMEUtils.BYTE_STRING_CRLF_BYTES)) {
                    this.handleExceptions(new MultiPartIllegalFormatException("Malformed multipart mime request. Headers are improperly constructed."));
                    return null;
                }
                int currentHeaderStart = MultiPartMIMEUtils.CRLF_BYTES.length;
                StringBuilder runningFoldedHeader = new StringBuilder();
                for (int i = MultiPartMIMEUtils.CRLF_BYTES.length; i < headerBytes.length() - MultiPartMIMEUtils.CRLF_BYTES.length; ++i) {
                    ByteString currentWindow = headerBytes.slice(i, MultiPartMIMEUtils.CRLF_BYTES.length);
                    if (!currentWindow.equals((Object)MultiPartMIMEUtils.BYTE_STRING_CRLF_BYTES)) continue;
                    ByteString currentHeader = headerBytes.slice(currentHeaderStart, i - currentHeaderStart);
                    String header = currentHeader.asString(Charset.defaultCharset());
                    if (headerBytes.getByte(i + MultiPartMIMEUtils.CRLF_BYTES.length) == 32 || headerBytes.getByte(i + MultiPartMIMEUtils.CRLF_BYTES.length) == 9) {
                        runningFoldedHeader.append(header + "\r\n");
                    } else {
                        int colonIndex;
                        if (runningFoldedHeader.length() != 0) {
                            runningFoldedHeader.append(header);
                            header = runningFoldedHeader.toString();
                            runningFoldedHeader.setLength(0);
                        }
                        if ((colonIndex = header.indexOf(":")) == -1) {
                            this.handleExceptions(new MultiPartIllegalFormatException("Malformed multipart mime request. Individual headers are improperly formatted."));
                            return null;
                        }
                        headers.put(header.substring(0, colonIndex).trim(), header.substring(colonIndex + 1, header.length()).trim());
                    }
                    currentHeaderStart = i + MultiPartMIMEUtils.CRLF_BYTES.length;
                }
            }
            return headers;
        }

        void handleExceptions(Throwable throwable) {
            this._rh.cancel();
            if (MultiPartMIMEReader.this._currentSinglePartMIMEReader != null) {
                MultiPartMIMEReader.this._currentSinglePartMIMEReader._singleReaderState = SingleReaderState.FINISHED;
                try {
                    MultiPartMIMEReader.this._currentSinglePartMIMEReader._callback.onStreamError(throwable);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            MultiPartMIMEReader.this._multiPartReaderState = MultiPartReaderState.FINISHED;
            try {
                MultiPartMIMEReader.this._clientCallback.onStreamError(throwable);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        private R2MultiPartMIMEReader(String boundary) {
            this._firstBoundary = "--" + boundary;
            this._normalBoundary = "\r\n--" + boundary;
            this._finishingBoundary = this._normalBoundary + "--";
            this._firstBoundaryBytes = this._firstBoundary.getBytes();
            this._normalBoundaryBytes = this._normalBoundary.getBytes();
            this._finishingBoundaryBytes = this._finishingBoundary.getBytes();
        }
    }
}

