/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.instrumented.qualitychecker;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumentable;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.qualitychecker.row.RowLevelPolicy;

abstract class InstrumentedRowLevelPolicyBase
extends RowLevelPolicy
implements Instrumentable,
Closeable {
    private final boolean instrumentationEnabled;
    private MetricContext metricContext;
    private Optional<Meter> recordsMeter;
    private Optional<Meter> passedRecordsMeter;
    private Optional<Meter> failedRecordsMeter;
    private Optional<Timer> policyTimer;
    protected final Closer closer;

    public InstrumentedRowLevelPolicyBase(State state, RowLevelPolicy.Type type) {
        this(state, type, Optional.absent());
    }

    protected InstrumentedRowLevelPolicyBase(State state, RowLevelPolicy.Type type, Optional<Class<?>> classTag) {
        super(state, type);
        this.instrumentationEnabled = GobblinMetrics.isEnabled((State)state);
        this.closer = Closer.create();
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.getMetricContext(state, (Class)classTag.or(this.getClass())));
        this.regenerateMetrics();
    }

    @Override
    public void switchMetricContext(List<Tag<?>> tags) {
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.newContextFromReferenceContext(this.metricContext, tags, (Optional<String>)Optional.absent()));
        this.regenerateMetrics();
    }

    @Override
    public void switchMetricContext(MetricContext context) {
        this.metricContext = context;
        this.regenerateMetrics();
    }

    protected void regenerateMetrics() {
        if (this.isInstrumentationEnabled()) {
            this.recordsMeter = Optional.of((Object)this.metricContext.meter("gobblin.qualitychecker.records.in"));
            this.passedRecordsMeter = Optional.of((Object)this.metricContext.meter("gobblin.qualitychecker.records.passed"));
            this.failedRecordsMeter = Optional.of((Object)this.metricContext.meter("gobblin.qualitychecker.records.failed"));
            this.policyTimer = Optional.of((Object)this.metricContext.timer("gobblin.qualitychecker.check.time"));
        } else {
            this.recordsMeter = Optional.absent();
            this.passedRecordsMeter = Optional.absent();
            this.failedRecordsMeter = Optional.absent();
            this.policyTimer = Optional.absent();
        }
    }

    @Override
    public List<Tag<?>> generateTags(State state) {
        return Lists.newArrayList();
    }

    @Override
    public boolean isInstrumentationEnabled() {
        return this.instrumentationEnabled;
    }

    public RowLevelPolicy.Result executePolicy(Object record) {
        if (!this.isInstrumentationEnabled()) {
            return this.executePolicyImpl(record);
        }
        long startTime = System.nanoTime();
        this.beforeCheck(record);
        RowLevelPolicy.Result result = this.executePolicyImpl(record);
        this.afterCheck(result, startTime);
        return result;
    }

    public void beforeCheck(Object record) {
        Instrumented.markMeter(this.recordsMeter);
    }

    public void afterCheck(RowLevelPolicy.Result result, long startTimeNanos) {
        switch (result) {
            case FAILED: {
                Instrumented.markMeter(this.failedRecordsMeter);
                break;
            }
            case PASSED: {
                Instrumented.markMeter(this.passedRecordsMeter);
                break;
            }
        }
        Instrumented.updateTimer(this.policyTimer, System.nanoTime() - startTimeNanos, TimeUnit.NANOSECONDS);
    }

    public abstract RowLevelPolicy.Result executePolicyImpl(Object var1);

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    @Override
    public MetricContext getMetricContext() {
        return this.metricContext;
    }
}

