/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.data.DataComplex;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.internal.common.util.CollectionUtils;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.RequestBuilder;
import com.linkedin.restli.client.RestliRequestOptions;
import com.linkedin.restli.client.base.BuilderBase;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ResourceSpec;
import com.linkedin.util.ArgumentUtil;
import java.lang.reflect.Array;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractRequestBuilder<K, V, R extends Request<?>>
extends BuilderBase
implements RequestBuilder<R> {
    protected static final char HEADER_DELIMITER = ',';
    protected final ResourceSpec _resourceSpec;
    private Map<String, String> _headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private List<HttpCookie> _cookies = new ArrayList<HttpCookie>();
    private final Map<String, Object> _queryParams = new HashMap<String, Object>();
    private final Map<String, Class<?>> _queryParamClasses = new HashMap();
    private final Map<String, Object> _pathKeys = new HashMap<String, Object>();
    private final CompoundKey _assocKey = new CompoundKey();

    protected AbstractRequestBuilder(String baseUriTemplate, ResourceSpec resourceSpec, RestliRequestOptions requestOptions) {
        super(baseUriTemplate, requestOptions);
        this._resourceSpec = resourceSpec;
        this._requestOptions = requestOptions;
    }

    public AbstractRequestBuilder<K, V, R> addHeader(String name, String value) {
        if (value != null) {
            String currValue = this._headers.get(name);
            String newValue = currValue == null ? value : currValue + ',' + value;
            this._headers.put(name, newValue);
        }
        return this;
    }

    public AbstractRequestBuilder<K, V, R> setHeader(String name, String value) {
        this._headers.put(name, value);
        return this;
    }

    protected String getHeader(String name) {
        return this._headers.get(name);
    }

    public AbstractRequestBuilder<K, V, R> setHeaders(Map<String, String> headers) {
        this._headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this._headers.putAll(headers);
        return this;
    }

    public AbstractRequestBuilder<K, V, R> addCookie(HttpCookie cookie) {
        if (cookie != null) {
            this._cookies.add(cookie);
        }
        return this;
    }

    public AbstractRequestBuilder<K, V, R> setCookies(List<HttpCookie> cookies) {
        for (HttpCookie cookie : cookies) {
            this.addCookie(cookie);
        }
        return this;
    }

    public AbstractRequestBuilder<K, V, R> clearCookies() {
        this._cookies = new ArrayList<HttpCookie>();
        return this;
    }

    protected List<HttpCookie> getCookies() {
        return this._cookies;
    }

    public AbstractRequestBuilder<K, V, R> setReqParam(String key, Object value) {
        ArgumentUtil.notNull((Object)value, (String)"value");
        return this.setParam(key, value);
    }

    public AbstractRequestBuilder<K, V, R> setReqParam(String key, Object value, Class<?> clazz) {
        ArgumentUtil.notNull((Object)value, (String)"value");
        return this.setParam(key, value, clazz);
    }

    public AbstractRequestBuilder<K, V, R> setParam(String key, Object value) {
        if (value == null) {
            return this;
        }
        return this.setParam(key, value, value.getClass());
    }

    public AbstractRequestBuilder<K, V, R> setParam(String key, Object value, Class<?> clazz) {
        if (value == null) {
            return this;
        }
        this._queryParams.put(key, value);
        this._queryParamClasses.put(key, clazz);
        return this;
    }

    public AbstractRequestBuilder<K, V, R> addReqParam(String key, Object value) {
        ArgumentUtil.notNull((Object)value, (String)"value");
        return this.addParam(key, value);
    }

    public AbstractRequestBuilder<K, V, R> addReqParam(String key, Object value, Class<?> clazz) {
        ArgumentUtil.notNull((Object)value, (String)"value");
        return this.addParam(key, value, clazz);
    }

    public AbstractRequestBuilder<K, V, R> addParam(String key, Object value) {
        if (value == null) {
            return this;
        }
        return this.addParam(key, value, value.getClass());
    }

    public AbstractRequestBuilder<K, V, R> addParam(String key, Object value, Class<?> clazz) {
        if (value == null) {
            return this;
        }
        Object existingData = this._queryParams.get(key);
        if (existingData == null) {
            ArrayList<Object> newData = new ArrayList<Object>();
            newData.add(value);
            this.setParam(key, newData);
        } else if (existingData instanceof Collection) {
            ((Collection)existingData).add(value);
        } else if (existingData instanceof Iterable) {
            ArrayList<Object> newData = new ArrayList<Object>();
            for (Object d : (Iterable)existingData) {
                newData.add(d);
            }
            newData.add(value);
            this.setParam(key, newData);
        } else {
            throw new IllegalStateException("Query parameter is already set to non-iterable value. Reset with null value then add new query parameter.");
        }
        this._queryParamClasses.put(key, clazz);
        return this;
    }

    public AbstractRequestBuilder<K, V, R> pathKey(String name, Object value) {
        this._pathKeys.put(name, value);
        return this;
    }

    public AbstractRequestBuilder<K, V, R> setRequestOptions(RestliRequestOptions options) {
        this._requestOptions = options;
        return this;
    }

    protected final void addKeys(Collection<K> ids) {
        if (ids == null) {
            throw new IllegalArgumentException("null ids");
        }
        HashSet<K> existingIds = (HashSet<K>)this._queryParams.get("ids");
        if (existingIds == null) {
            existingIds = new HashSet<K>();
            this._queryParams.put("ids", existingIds);
        }
        for (K id : ids) {
            if (id == null) {
                throw new IllegalArgumentException("Null key");
            }
            existingIds.add(id);
        }
    }

    protected boolean hasParam(String parameterName) {
        return this._queryParams.containsKey(parameterName);
    }

    protected Object getParam(String parameterName) {
        return this._queryParams.get(parameterName);
    }

    protected final void addKey(K id) {
        this.addKeys(Collections.singletonList(id));
    }

    protected void addAssocKey(String key, Object value) {
        this._assocKey.append(key, value);
    }

    protected void addFields(PathSpec ... fieldPaths) {
        if (this._queryParams.containsKey("fields")) {
            throw new IllegalStateException("Entity projection fields already set on this request: " + this._queryParams.get("fields"));
        }
        this.setParam("fields", fieldPaths);
    }

    protected void addMetadataFields(PathSpec ... fieldPaths) {
        if (this._queryParams.containsKey("metadataFields")) {
            throw new IllegalStateException("Metadata projection fields already set on this request: " + this._queryParams.get("metadataFields"));
        }
        this.setParam("metadataFields", fieldPaths);
    }

    protected void addPagingFields(PathSpec ... fieldPaths) {
        if (this._queryParams.containsKey("pagingFields")) {
            throw new IllegalStateException("Paging projection fields already set on this request: " + this._queryParams.get("pagingFields"));
        }
        this.setParam("pagingFields", fieldPaths);
    }

    protected Map<String, Object> buildReadOnlyQueryParameters() {
        return AbstractRequestBuilder.getReadOnlyQueryParameters(this._queryParams);
    }

    protected static Map<String, Object> getReadOnlyQueryParameters(Map<String, Object> queryParams) {
        try {
            HashMap<String, Object> readOnlyCopy = new HashMap<String, Object>(CollectionUtils.getMapInitialCapacity((int)queryParams.size(), (float)0.75f), 0.75f);
            for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                readOnlyCopy.put(key, AbstractRequestBuilder.getReadOnlyJavaObject(value));
            }
            return Collections.unmodifiableMap(readOnlyCopy);
        }
        catch (CloneNotSupportedException cloneException) {
            throw new IllegalArgumentException("Query parameters cannot be cloned.", cloneException);
        }
    }

    protected Map<String, Class<?>> getQueryParamClasses() {
        return this._queryParamClasses;
    }

    protected Map<String, Object> buildReadOnlyPathKeys() {
        return AbstractRequestBuilder.getReadOnlyPathKeys(this._pathKeys);
    }

    protected static Map<String, Object> getReadOnlyPathKeys(Map<String, Object> pathKeys) {
        try {
            HashMap<String, Object> readOnlyCopy = new HashMap<String, Object>(CollectionUtils.getMapInitialCapacity((int)pathKeys.size(), (float)0.75f), 0.75f);
            for (Map.Entry<String, Object> entry : pathKeys.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                readOnlyCopy.put(key, AbstractRequestBuilder.getReadOnlyOrCopyKeyObject(value));
            }
            return Collections.unmodifiableMap(readOnlyCopy);
        }
        catch (CloneNotSupportedException cloneException) {
            throw new IllegalArgumentException("Path keys cannot be cloned.", cloneException);
        }
    }

    protected <T extends DataTemplate<?>> T getReadOnlyOrCopyDataTemplate(T value) throws CloneNotSupportedException {
        return AbstractRequestBuilder.getReadOnlyOrCopyDataTemplateObject(value);
    }

    private static <D extends DataTemplate<?>> D getReadOnlyOrCopyDataTemplateObject(D value) throws CloneNotSupportedException {
        DataComplex dataComplex;
        if (value == null) {
            return null;
        }
        Object data = value.data();
        if (data instanceof DataComplex && !(dataComplex = (DataComplex)data).isMadeReadOnly()) {
            value = value.copy();
            ((DataComplex)value.data()).makeReadOnly();
        }
        return value;
    }

    protected K getReadOnlyOrCopyKey(K key) throws CloneNotSupportedException {
        return AbstractRequestBuilder.getReadOnlyOrCopyKeyObject(key);
    }

    private static <Key> Key getReadOnlyOrCopyKeyObject(Key key) throws CloneNotSupportedException {
        CompoundKey compoundKey;
        if (key instanceof ComplexResourceKey) {
            ComplexResourceKey complexKey = (ComplexResourceKey)key;
            if (!complexKey.isReadOnly()) {
                complexKey = complexKey.copy();
                complexKey.makeReadOnly();
                key = complexKey;
            }
        } else if (key instanceof CompoundKey && !(compoundKey = (CompoundKey)key).isReadOnly()) {
            compoundKey = compoundKey.copy();
            compoundKey.makeReadOnly();
            key = compoundKey;
        }
        return key;
    }

    private static Object getReadOnlyJavaObject(Object value) throws CloneNotSupportedException {
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            ArrayList<Object> list = new ArrayList<Object>(arr.length);
            for (Object o : arr) {
                list.add(AbstractRequestBuilder.getReadOnlyJavaObject(o));
            }
            return Collections.unmodifiableList(list);
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(value, i));
            }
            return Collections.unmodifiableList(list);
        }
        if (value instanceof ComplexResourceKey || value instanceof CompoundKey) {
            return AbstractRequestBuilder.getReadOnlyOrCopyKeyObject(value);
        }
        if (value instanceof DataTemplate) {
            return AbstractRequestBuilder.getReadOnlyOrCopyDataTemplateObject((DataTemplate)value);
        }
        if (value instanceof Iterable) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (Iterable)value) {
                list.add(AbstractRequestBuilder.getReadOnlyJavaObject(o));
            }
            return Collections.unmodifiableList(list);
        }
        return value;
    }

    protected CompoundKey buildReadOnlyAssocKey() {
        try {
            return AbstractRequestBuilder.getReadOnlyOrCopyKeyObject(this._assocKey);
        }
        catch (CloneNotSupportedException cloneException) {
            throw new IllegalArgumentException("Assoc keys cannot be cloned.", cloneException);
        }
    }

    protected Map<String, String> buildReadOnlyHeaders() {
        return AbstractRequestBuilder.getReadOnlyHeaders(this._headers);
    }

    protected List<HttpCookie> buildReadOnlyCookies() {
        return AbstractRequestBuilder.getReadOnlyCookies(this._cookies);
    }

    protected static Map<String, String> getReadOnlyHeaders(Map<String, String> headers) {
        TreeMap<String, String> copyHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        copyHeaders.putAll(headers);
        return Collections.unmodifiableMap(copyHeaders);
    }

    protected static List<HttpCookie> getReadOnlyCookies(List<HttpCookie> cookies) {
        return Collections.unmodifiableList(cookies);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{_assocKey=").append(this._assocKey);
        sb.append(", _baseURITemplate='").append(this.getBaseUriTemplate()).append('\'');
        sb.append(", _headers=").append(this._headers);
        sb.append(", _pathKeys=").append(this._pathKeys);
        sb.append(", _resourceSpec=").append(this._resourceSpec);
        sb.append(", _queryParams=").append(AbstractRequestBuilder.getBoundedString(this._queryParams, 32));
        sb.append('}');
        return sb.toString();
    }

    private static String getBoundedString(Map<?, ?> map, int maxEntryCount) {
        if (map == null || map.size() < maxEntryCount) {
            return String.valueOf(map);
        }
        return new ArrayList(map.entrySet()).subList(0, maxEntryCount).toString() + " (truncated)";
    }
}

