/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.stream.StreamException;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.internal.client.ExceptionUtil;
import com.linkedin.restli.internal.client.RestResponseDecoder;

final class RestLiStreamCallbackAdapter<T>
implements Callback<StreamResponse> {
    private final Callback<Response<T>> _wrappedCallback;
    private final RestResponseDecoder<T> _decoder;

    public RestLiStreamCallbackAdapter(RestResponseDecoder<T> decoder, Callback<Response<T>> wrappedCallback) {
        this._decoder = decoder;
        this._wrappedCallback = wrappedCallback;
    }

    public void onError(Throwable e) {
        if (e instanceof StreamException) {
            Messages.toRestException((StreamException)((StreamException)e), (Callback)new Callback<RestException>(){

                public void onError(Throwable e) {
                    RestLiStreamCallbackAdapter.this._wrappedCallback.onError(e);
                }

                public void onSuccess(RestException result) {
                    RestLiStreamCallbackAdapter.this._wrappedCallback.onError((Throwable)ExceptionUtil.exceptionForThrowable((Throwable)result, RestLiStreamCallbackAdapter.this._decoder));
                }
            });
            return;
        }
        if (e instanceof RemoteInvocationException) {
            this._wrappedCallback.onError(e);
            return;
        }
        this._wrappedCallback.onError((Throwable)new RemoteInvocationException(e));
    }

    public void onSuccess(StreamResponse result) {
        try {
            this._decoder.decodeResponse(result, this._wrappedCallback);
        }
        catch (Exception exception) {
            this.onError(exception);
        }
    }
}

