/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client.multiplexer;

import com.linkedin.common.callback.Callback;
import com.linkedin.data.ByteString;
import com.linkedin.data.DataMap;
import com.linkedin.data.template.GetMode;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import com.linkedin.r2.message.rest.RestStatus;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.RestLiDecodingException;
import com.linkedin.restli.client.multiplexer.MultiplexedResponse;
import com.linkedin.restli.common.multiplexer.IndividualBody;
import com.linkedin.restli.common.multiplexer.IndividualResponse;
import com.linkedin.restli.common.multiplexer.IndividualResponseMap;
import com.linkedin.restli.common.multiplexer.MultiplexedResponseContent;
import com.linkedin.restli.internal.client.EntityResponseDecoder;
import com.linkedin.restli.internal.common.CookieUtil;
import com.linkedin.restli.internal.common.DataMapConverter;
import com.linkedin.restli.internal.common.HeaderUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.activation.MimeTypeParseException;

public class MultiplexedCallback
implements Callback<RestResponse> {
    private final EntityResponseDecoder<MultiplexedResponseContent> _decoder = new EntityResponseDecoder<MultiplexedResponseContent>(MultiplexedResponseContent.class);
    private final Map<Integer, Callback<RestResponse>> _callbacks;
    private final Callback<MultiplexedResponse> _aggregatedCallback;

    public MultiplexedCallback(Map<Integer, Callback<RestResponse>> callbacks, Callback<MultiplexedResponse> aggregatedCallback) {
        this._callbacks = callbacks;
        this._aggregatedCallback = aggregatedCallback;
    }

    public void onError(Throwable e) {
        for (Callback<RestResponse> callback : this._callbacks.values()) {
            callback.onError(e);
        }
        this._aggregatedCallback.onError(e);
    }

    public void onSuccess(RestResponse restResponse) {
        Response<MultiplexedResponseContent> response;
        try {
            response = this._decoder.decodeResponse(restResponse);
        }
        catch (RestLiDecodingException e) {
            this.onError((Throwable)((Object)e));
            return;
        }
        this.notifyIndividualCallbacks(response);
        this.notifyAggregatedCallback(response);
    }

    private void notifyIndividualCallbacks(Response<MultiplexedResponseContent> muxResponse) {
        IndividualResponseMap individualResponses = muxResponse.getEntity().getResponses();
        for (Map.Entry individualResponseMapEntry : individualResponses.entrySet()) {
            RestResponse individualRestResponse;
            Integer id = Integer.valueOf((String)individualResponseMapEntry.getKey());
            IndividualResponse individualResponse = (IndividualResponse)individualResponseMapEntry.getValue();
            Callback<RestResponse> callback = this._callbacks.get(id);
            try {
                individualRestResponse = MultiplexedCallback.buildIndividualRestResponse(muxResponse, individualResponse);
            }
            catch (MimeTypeParseException e) {
                callback.onError((Throwable)((Object)new RestLiDecodingException("Could not convert IndividualResponse to individual RestRestponse due to an invalid content type, id=" + id, e)));
                return;
            }
            catch (IOException e) {
                callback.onError((Throwable)((Object)new RestLiDecodingException("Could not convert IndividualResponse to individual RestRestponse, id=" + id, e)));
                return;
            }
            if (RestStatus.isOK((int)individualResponse.getStatus())) {
                callback.onSuccess((Object)individualRestResponse);
                continue;
            }
            RestException exception = new RestException(individualRestResponse, "Received error " + individualRestResponse.getStatus());
            callback.onError((Throwable)exception);
        }
    }

    private static RestResponse buildIndividualRestResponse(Response<?> envelopeResponse, IndividualResponse individualResponse) throws IOException, MimeTypeParseException {
        IndividualBody body = individualResponse.getBody(GetMode.NULL);
        ByteString entity = body != null ? DataMapConverter.dataMapToByteString((Map)individualResponse.getHeaders(), (DataMap)body.data()) : ByteString.empty();
        return ((RestResponseBuilder)((RestResponseBuilder)((RestResponseBuilder)new RestResponseBuilder().setStatus(individualResponse.getStatus().intValue())).setHeaders(MultiplexedCallback.inheritHeaders(individualResponse, envelopeResponse))).setCookies(CookieUtil.encodeSetCookies(envelopeResponse.getCookies()))).setEntity(entity).build();
    }

    private static Map<String, String> inheritHeaders(IndividualResponse individualResponse, Response<?> envelopeResponse) {
        Map envelopeHeaders = HeaderUtil.removeHeaders(envelopeResponse.getHeaders(), (Collection)HeaderUtil.NONINHERITABLE_RESPONSE_HEADERS);
        return HeaderUtil.mergeHeaders((Map)envelopeHeaders, (Map)individualResponse.getHeaders());
    }

    private void notifyAggregatedCallback(Response<MultiplexedResponseContent> response) {
        MultiplexedResponse muxResponse = new MultiplexedResponse(response.getStatus(), response.getHeaders());
        this._aggregatedCallback.onSuccess((Object)muxResponse);
    }
}

