/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.client;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.client.response.BatchKVResponse;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.EntityResponse;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.internal.client.RestResponseDecoder;
import com.linkedin.restli.internal.client.response.BatchEntityResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class BatchEntityResponseDecoder<K, V extends RecordTemplate>
extends RestResponseDecoder<BatchKVResponse<K, EntityResponse<V>>> {
    private final TypeSpec<V> _entityType;
    private final TypeSpec<K> _keyType;
    private final Map<String, CompoundKey.TypeInfo> _keyParts;
    private final ComplexKeySpec<?, ?> _complexKeyType;

    public BatchEntityResponseDecoder(TypeSpec<V> entityType, TypeSpec<K> keyType, Map<String, CompoundKey.TypeInfo> keyParts, ComplexKeySpec<?, ?> complexKeyType) {
        this._entityType = entityType;
        this._keyType = keyType;
        this._keyParts = keyParts;
        this._complexKeyType = complexKeyType;
    }

    @Override
    public Class<?> getEntityClass() {
        return EntityResponse.class;
    }

    @Override
    public BatchKVResponse<K, EntityResponse<V>> wrapResponse(DataMap dataMap, Map<String, String> headers, ProtocolVersion version) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (dataMap == null) {
            return null;
        }
        return new BatchEntityResponse<K, V>(dataMap, this._keyType, this._entityType, this._keyParts, this._complexKeyType, version);
    }
}

