/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.client;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.RestLiDecodingException;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.IdEntityResponse;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.internal.client.ResponseImpl;
import com.linkedin.restli.internal.client.RestResponseDecoder;
import com.linkedin.restli.internal.common.HeaderUtil;
import com.linkedin.restli.internal.common.ResponseUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.TreeMap;

public class IdEntityResponseDecoder<K, V extends RecordTemplate>
extends RestResponseDecoder<IdEntityResponse<K, V>> {
    private final TypeSpec<K> _keyType;
    private final Map<String, CompoundKey.TypeInfo> _keyParts;
    private final ComplexKeySpec<?, ?> _complexKeyType;
    private final Class<V> _entityClass;

    public IdEntityResponseDecoder(TypeSpec<K> keyType, Map<String, CompoundKey.TypeInfo> keyParts, ComplexKeySpec<?, ?> complexKeyType, Class<V> entityClass) {
        this._keyType = keyType;
        this._keyParts = keyParts;
        this._complexKeyType = complexKeyType;
        this._entityClass = entityClass;
    }

    @Override
    public Class<?> getEntityClass() {
        return this._entityClass;
    }

    @Override
    public Response<IdEntityResponse<K, V>> decodeResponse(RestResponse restResponse) throws RestLiDecodingException {
        Response rawResponse = super.decodeResponse(restResponse);
        TreeMap<String, String> modifiableHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        modifiableHeaders.putAll(rawResponse.getHeaders());
        modifiableHeaders.remove("X-LinkedIn-Id");
        modifiableHeaders.remove("X-RestLi-Id");
        return new ResponseImpl<IdEntityResponse<K, V>>(rawResponse.getStatus(), (Map<String, String>)modifiableHeaders, rawResponse.getCookies(), rawResponse.getEntity(), rawResponse.getError());
    }

    @Override
    public IdEntityResponse<K, V> wrapResponse(DataMap dataMap, Map<String, String> headers, ProtocolVersion version) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        String id = HeaderUtil.getIdHeaderValue(headers);
        Object key = id == null ? null : ResponseUtils.convertKey((String)id, this._keyType, this._keyParts, this._complexKeyType, (ProtocolVersion)version);
        RecordTemplate entity = dataMap == null ? null : (RecordTemplate)this._entityClass.getConstructor(DataMap.class).newInstance(dataMap);
        return new IdEntityResponse(key, entity);
    }
}

