/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.client;

import com.linkedin.data.DataMap;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.common.CollectionRequest;
import com.linkedin.restli.common.KeyValueRecord;
import com.linkedin.restli.common.PatchRequest;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.ResourceProperties;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.internal.client.CollectionRequestUtil;

public class RequestBodyTransformer {
    private RequestBodyTransformer() {
    }

    public static <T> DataMap transform(Request<T> request, ProtocolVersion version) {
        ResourceProperties resourceProperties = null;
        switch (request.getMethod()) {
            case BATCH_UPDATE: {
                resourceProperties = request.getResourceProperties();
                return CollectionRequestUtil.convertToBatchRequest((CollectionRequest<KeyValueRecord>)((CollectionRequest)request.getInputRecord()), resourceProperties.getKeyType(), resourceProperties.getComplexKeyType(), resourceProperties.getKeyParts(), resourceProperties.getValueType(), version).data();
            }
            case BATCH_PARTIAL_UPDATE: {
                resourceProperties = request.getResourceProperties();
                return CollectionRequestUtil.convertToBatchRequest((CollectionRequest<KeyValueRecord>)((CollectionRequest)request.getInputRecord()), resourceProperties.getKeyType(), resourceProperties.getComplexKeyType(), resourceProperties.getKeyParts(), new TypeSpec(PatchRequest.class), version).data();
            }
        }
        return request.getInputRecord().data();
    }
}

