/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.client;

import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.RestLiResponseException;
import com.linkedin.restli.client.response.CreateResponse;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.IdEntityResponse;
import com.linkedin.restli.common.IdResponse;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.attachments.RestLiAttachmentReader;
import com.linkedin.restli.internal.common.ProtocolVersionUtil;
import com.linkedin.restli.internal.common.URIParamUtils;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ResponseImpl<T>
implements Response<T> {
    private int _status = 102;
    private final Map<String, String> _headers;
    private final List<HttpCookie> _cookies;
    private T _entity;
    private RestLiResponseException _error;
    private RestLiAttachmentReader _attachmentReader;

    ResponseImpl(Response<T> origin, RestLiResponseException error) {
        this(origin, origin.getEntity());
        this._error = error;
    }

    ResponseImpl(int status, Map<String, String> headers, List<HttpCookie> cookies, RestLiResponseException error) {
        this(status, headers, cookies);
        this._error = error;
    }

    public ResponseImpl(Response<?> origin, T entity) {
        this(origin.getStatus(), origin.getHeaders(), origin.getCookies());
        this._entity = entity;
    }

    public ResponseImpl(int status, Map<String, String> headers, List<HttpCookie> cookies, T entity, RestLiResponseException error) {
        this(status, headers, cookies);
        this._entity = entity;
        this._error = error;
    }

    ResponseImpl(int status, Map<String, String> headers, List<HttpCookie> cookies) {
        this._status = status;
        this._headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this._headers.putAll(headers);
        this._cookies = new ArrayList<HttpCookie>(cookies);
    }

    @Override
    public int getStatus() {
        return this._status;
    }

    @Override
    public T getEntity() {
        return this._entity;
    }

    public void setEntity(T entity) {
        this._entity = entity;
    }

    @Override
    public String getHeader(String name) {
        return this._headers.get(name);
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this._headers);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return Collections.unmodifiableList(this._cookies);
    }

    @Override
    @Deprecated
    public String getId() {
        if (this._entity instanceof CreateResponse || this._entity instanceof IdResponse || this._entity instanceof IdEntityResponse) {
            Object id = this.checkAndReturnId();
            ProtocolVersion protocolVersion = ProtocolVersionUtil.extractProtocolVersion(this._headers);
            return URIParamUtils.encodeKeyForHeader((Object)id, (ProtocolVersion)protocolVersion);
        }
        return null;
    }

    private Object checkAndReturnId() {
        String castMessage;
        Object id;
        if (this._entity instanceof CreateResponse) {
            CreateResponse createResponse = (CreateResponse)((Object)this._entity);
            id = createResponse.getId();
            castMessage = "CreateResponse";
        } else if (this._entity instanceof IdEntityResponse) {
            IdEntityResponse idEntityResponse = (IdEntityResponse)this._entity;
            id = idEntityResponse.getId();
            castMessage = "IdEntityResponse";
        } else {
            IdResponse idResponse = (IdResponse)this._entity;
            id = idResponse.getId();
            castMessage = "IdResponse";
        }
        if (id instanceof CompoundKey || id instanceof ComplexResourceKey) {
            String baseErrorMessage = "Cannot call getId() for complex or compound keys! Please cast the object returned by getEntity() to a %s and call the getId() method on that.";
            throw new UnsupportedOperationException(String.format(baseErrorMessage, castMessage));
        }
        return id;
    }

    @Override
    public URI getLocation() {
        return URI.create(this.getHeader("Location"));
    }

    @Override
    public RestLiResponseException getError() {
        return this._error;
    }

    @Override
    public boolean hasError() {
        return this._error != null;
    }

    @Override
    public boolean hasAttachments() {
        return this._attachmentReader != null;
    }

    @Override
    public RestLiAttachmentReader getAttachmentReader() {
        return this._attachmentReader;
    }

    public void setAttachmentReader(RestLiAttachmentReader attachmentReader) {
        this._attachmentReader = attachmentReader;
    }
}

