/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractBeanField;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldDate;
import com.opencsv.bean.BeanFieldPrimitiveTypes;
import com.opencsv.bean.CsvBind;
import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvCustomBindByName;
import com.opencsv.bean.CsvDate;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.exceptions.CsvBadConverterException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HeaderColumnNameMappingStrategy<T>
implements MappingStrategy<T> {
    protected String[] header;
    protected Map<String, Integer> indexLookup = new HashMap<String, Integer>();
    protected Map<String, PropertyDescriptor> descriptorMap = null;
    protected Map<String, BeanField> fieldMap = null;
    protected Class<? extends T> type;
    protected boolean annotationDriven;

    @Override
    public void captureHeader(CSVReader reader) throws IOException {
        this.header = reader.readNext();
    }

    protected void createIndexLookup(String[] values) {
        if (this.indexLookup.isEmpty()) {
            for (int i = 0; i < values.length; ++i) {
                this.indexLookup.put(values[i], i);
            }
        }
    }

    protected void resetIndexMap() {
        this.indexLookup.clear();
    }

    @Override
    public Integer getColumnIndex(String name) {
        if (null == this.header) {
            throw new IllegalStateException("The header row hasn't been read yet.");
        }
        this.createIndexLookup(this.header);
        return this.indexLookup.get(name);
    }

    @Override
    public PropertyDescriptor findDescriptor(int col) throws IntrospectionException {
        String columnName = this.getColumnName(col);
        return StringUtils.isNotBlank((CharSequence)columnName) ? this.findDescriptor(columnName) : null;
    }

    @Override
    public BeanField findField(int col) throws CsvBadConverterException {
        String columnName = this.getColumnName(col);
        return StringUtils.isNotBlank((CharSequence)columnName) ? this.findField(columnName) : null;
    }

    public String getColumnName(int col) {
        return null != this.header && col < this.header.length ? this.header[col] : null;
    }

    protected PropertyDescriptor findDescriptor(String name) throws IntrospectionException {
        if (null == this.descriptorMap) {
            this.descriptorMap = this.loadDescriptorMap();
        }
        return this.descriptorMap.get(name.toUpperCase().trim());
    }

    protected BeanField findField(String name) throws CsvBadConverterException {
        return this.fieldMap.get(name.toUpperCase().trim());
    }

    protected boolean matches(String name, PropertyDescriptor desc) {
        return desc.getName().equals(name.trim());
    }

    protected Map<String, PropertyDescriptor> loadDescriptorMap() throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor : descriptors = this.loadDescriptors(this.getType())) {
            map.put(descriptor.getName().toUpperCase().trim(), descriptor);
        }
        return map;
    }

    protected void loadFieldMap() throws CsvBadConverterException {
        this.fieldMap = new HashMap<String, BeanField>();
        for (Field field : this.loadFields(this.getType())) {
            boolean required;
            String columnName;
            if (field.isAnnotationPresent(CsvCustomBindByName.class)) {
                BeanField bean;
                columnName = field.getAnnotation(CsvCustomBindByName.class).column().toUpperCase().trim();
                Class<? extends AbstractBeanField> converter = field.getAnnotation(CsvCustomBindByName.class).converter();
                try {
                    bean = converter.newInstance();
                }
                catch (IllegalAccessException oldEx) {
                    CsvBadConverterException newEx = new CsvBadConverterException(converter, "There was a problem instantiating the custom converter " + converter.getCanonicalName());
                    newEx.initCause(oldEx);
                    throw newEx;
                }
                catch (InstantiationException oldEx) {
                    CsvBadConverterException newEx = new CsvBadConverterException(converter, "There was a problem instantiating the custom converter " + converter.getCanonicalName());
                    newEx.initCause(oldEx);
                    throw newEx;
                }
                bean.setField(field);
                this.fieldMap.put(columnName, bean);
                continue;
            }
            if (field.isAnnotationPresent(CsvBindByName.class)) {
                required = field.getAnnotation(CsvBindByName.class).required();
                columnName = field.getAnnotation(CsvBindByName.class).column().toUpperCase().trim();
                String locale = field.getAnnotation(CsvBindByName.class).locale();
                if (field.isAnnotationPresent(CsvDate.class)) {
                    String formatString = field.getAnnotation(CsvDate.class).value();
                    if (StringUtils.isEmpty((CharSequence)columnName)) {
                        this.fieldMap.put(field.getName().toUpperCase().trim(), new BeanFieldDate(field, required, formatString, locale));
                        continue;
                    }
                    this.fieldMap.put(columnName, new BeanFieldDate(field, required, formatString, locale));
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)columnName)) {
                    this.fieldMap.put(field.getName().toUpperCase().trim(), new BeanFieldPrimitiveTypes(field, required, locale));
                    continue;
                }
                this.fieldMap.put(columnName, new BeanFieldPrimitiveTypes(field, required, locale));
                continue;
            }
            required = field.getAnnotation(CsvBind.class).required();
            this.fieldMap.put(field.getName().toUpperCase().trim(), new BeanFieldPrimitiveTypes(field, required, null));
        }
    }

    private PropertyDescriptor[] loadDescriptors(Class<? extends T> cls) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        return beanInfo.getPropertyDescriptors();
    }

    private List<Field> loadFields(Class<? extends T> cls) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : cls.getDeclaredFields()) {
            if (!field.isAnnotationPresent(CsvBind.class) && !field.isAnnotationPresent(CsvBindByName.class) && !field.isAnnotationPresent(CsvCustomBindByName.class)) continue;
            fields.add(field);
        }
        this.annotationDriven = !fields.isEmpty();
        return fields;
    }

    @Override
    public T createBean() throws InstantiationException, IllegalAccessException {
        return this.type.newInstance();
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public void setType(Class<? extends T> type) throws CsvBadConverterException {
        this.type = type;
        this.loadFieldMap();
    }

    @Override
    public boolean isAnnotationDriven() {
        return this.annotationDriven;
    }
}

