/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.avro.JsonElementConversionFactory;
import org.apache.gobblin.ingestion.google.util.SchemaUtil;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterDataFetcher;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterExtractor;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterFilter;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.extract.QueryBasedSource;
import org.apache.gobblin.source.workunit.WorkUnit;

@Alpha
abstract class GoogleWebMasterSource
extends QueryBasedSource<String, String[]> {
    public static final String SOURCE_GOOGLE_WEBMASTER_PREFIX = "source.google_webmasters.";
    public static final String KEY_PROPERTY = "source.google_webmasters.property_urls";
    public static final String KEY_INCLUDE_SOURCE_PROPERTY = "source.google_webmasters.source_property.include";
    public static final String KEY_SOURCE_PROPERTY_COLUMN_NAME = "source.google_webmasters.source_property.column_name";
    public static final String KEY_REQUEST_FILTERS = "source.google_webmasters.request.filters";
    public static final String KEY_REQUEST_DIMENSIONS = "source.google_webmasters.request.dimensions";
    public static final String KEY_REQUEST_METRICS = "source.google_webmasters.request.metrics";
    public static final String KEY_REQUEST_PAGE_LIMIT = "source.google_webmasters.request.page_limit";
    public static final String KEY_REQUEST_HOT_START = "source.google_webmasters.request.hot_start";
    public static final String KEY_REQUEST_QUERY_LIMIT = "source.google_webmasters.request.query_limit";
    public static final String TUNING = "source.google_webmasters.request.tuning.";
    public static final String QUERIES_TUNING = "source.google_webmasters.request.tuning.get_queries.";
    public static final String KEY_QUERIES_TUNING_TIME_OUT = "source.google_webmasters.request.tuning.get_queries.time_out";
    public static final String KEY_QUERIES_TUNING_RETRIES = "source.google_webmasters.request.tuning.get_queries.max_reties";
    public static final String KEY_QUERIES_TUNING_COOL_DOWN = "source.google_webmasters.request.tuning.get_queries.cool_down_time";
    public static final String KEY_QUERIES_TUNING_BATCHES_PER_SECOND = "source.google_webmasters.request.tuning.get_queries.batches_per_second";
    public static final String KEY_QUERIES_TUNING_BATCH_SIZE = "source.google_webmasters.request.tuning.get_queries.batch_size";
    public static final String KEY_QUERIES_TUNING_GROUP_SIZE = "source.google_webmasters.request.tuning.get_queries.trie_group_size";
    public static final String KEY_REQUEST_TUNING_ALGORITHM = "source.google_webmasters.request.tuning.get_queries.apply_trie";
    public static final String PAGES_TUNING = "source.google_webmasters.request.tuning.get_pages.";
    public static final String KEY_PAGES_TUNING_REQUESTS_PER_SECOND = "source.google_webmasters.request.tuning.get_pages.requests_per_second";
    public static final String KEY_PAGES_TUNING_MAX_RETRIES = "source.google_webmasters.request.tuning.get_pages.max_retries";
    public static final String KEY_PAGES_TUNING_TIME_OUT = "source.google_webmasters.request.tuning.get_pages.time_out";
    private static final Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
    public static final boolean DEFAULT_INCLUDE_SOURCE_PROPERTY = false;
    public static final String DEFAULT_SOURCE_PROPERTY_COLUMN_NAME = "Source";

    GoogleWebMasterSource() {
    }

    public Extractor<String, String[]> getExtractor(WorkUnitState state) throws IOException {
        List<GoogleWebmasterFilter.Dimension> requestedDimensions = this.getRequestedDimensions(state);
        List<GoogleWebmasterDataFetcher.Metric> requestedMetrics = this.getRequestedMetrics(state);
        WorkUnit workunit = state.getWorkunit();
        String schema = workunit.getProp("source.schema");
        JsonArray schemaJson = new JsonParser().parse(schema).getAsJsonArray();
        HashMap<String, Integer> columnPositionMap = new HashMap<String, Integer>();
        for (int i = 0; i < schemaJson.size(); ++i) {
            JsonElement jsonElement = schemaJson.get(i);
            String columnName = jsonElement.getAsJsonObject().get("columnName").getAsString().toUpperCase();
            columnPositionMap.put(columnName, i);
        }
        if (workunit.getPropAsBoolean(KEY_INCLUDE_SOURCE_PROPERTY, false)) {
            String columnName = workunit.getProp(KEY_SOURCE_PROPERTY_COLUMN_NAME, DEFAULT_SOURCE_PROPERTY_COLUMN_NAME);
            schemaJson.add((JsonElement)SchemaUtil.createColumnJson(columnName, false, JsonElementConversionFactory.Type.STRING));
        }
        this.validateFilters(state.getProp(KEY_REQUEST_FILTERS));
        this.validateRequests(columnPositionMap, requestedDimensions, requestedMetrics);
        return this.createExtractor(state, columnPositionMap, requestedDimensions, requestedMetrics, schemaJson);
    }

    abstract GoogleWebmasterExtractor createExtractor(WorkUnitState var1, Map<String, Integer> var2, List<GoogleWebmasterFilter.Dimension> var3, List<GoogleWebmasterDataFetcher.Metric> var4, JsonArray var5) throws IOException;

    private void validateFilters(String filters) {
        String countryPrefix = "COUNTRY.";
        for (String filter : splitter.split((CharSequence)filters)) {
            if (!filter.toUpperCase().startsWith(countryPrefix)) continue;
            GoogleWebmasterFilter.validateCountryCode(filter.substring(countryPrefix.length()));
        }
    }

    private void validateRequests(Map<String, Integer> columnPositionMap, List<GoogleWebmasterFilter.Dimension> requestedDimensions, List<GoogleWebmasterDataFetcher.Metric> requestedMetrics) {
        for (GoogleWebmasterFilter.Dimension dimension : requestedDimensions) {
            Preconditions.checkState((boolean)columnPositionMap.containsKey(dimension.toString()), (Object)"Your requested dimension must exist in the source.schema.");
        }
        for (GoogleWebmasterDataFetcher.Metric metric : requestedMetrics) {
            Preconditions.checkState((boolean)columnPositionMap.containsKey(metric.toString()), (Object)"Your requested metric must exist in the source.schema.");
        }
    }

    private List<GoogleWebmasterFilter.Dimension> getRequestedDimensions(WorkUnitState wuState) {
        ArrayList<GoogleWebmasterFilter.Dimension> dimensions = new ArrayList<GoogleWebmasterFilter.Dimension>();
        String dimensionsString = wuState.getProp(KEY_REQUEST_DIMENSIONS);
        for (String dim : splitter.split((CharSequence)dimensionsString)) {
            dimensions.add(GoogleWebmasterFilter.Dimension.valueOf(dim.toUpperCase()));
        }
        return dimensions;
    }

    private List<GoogleWebmasterDataFetcher.Metric> getRequestedMetrics(WorkUnitState wuState) {
        ArrayList<GoogleWebmasterDataFetcher.Metric> metrics = new ArrayList<GoogleWebmasterDataFetcher.Metric>();
        String metricsString = wuState.getProp(KEY_REQUEST_METRICS);
        for (String metric : splitter.split((CharSequence)metricsString)) {
            metrics.add(GoogleWebmasterDataFetcher.Metric.valueOf(metric.toUpperCase()));
        }
        return metrics;
    }
}

