/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterFilter;
import org.apache.gobblin.ingestion.google.webmaster.SimpleProducerJob;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class ProducerJob {
    static final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    static final GsonBuilder gsonBuilder = new GsonBuilder();

    public abstract String getPage();

    public abstract String getStartDate();

    public abstract String getEndDate();

    public abstract GoogleWebmasterFilter.FilterOperator getOperator();

    public abstract int getPagesSize();

    public List<? extends ProducerJob> partitionJobs() {
        DateTime end;
        DateTime start = dateFormatter.parseDateTime(this.getStartDate());
        int days = Days.daysBetween((ReadableInstant)start, (ReadableInstant)(end = dateFormatter.parseDateTime(this.getEndDate()))).getDays();
        if (days <= 0) {
            return new ArrayList();
        }
        int step = days / 2;
        return Arrays.asList(new SimpleProducerJob(this.getPage(), this.getStartDate(), dateFormatter.print((ReadableInstant)start.plusDays(step))), new SimpleProducerJob(this.getPage(), dateFormatter.print((ReadableInstant)start.plusDays(step + 1)), this.getEndDate()));
    }

    public static String serialize(Collection<ProducerJob> jobs) {
        ArrayList<SimpleProducerJob> producerJobs = new ArrayList<SimpleProducerJob>(jobs.size());
        for (ProducerJob job : jobs) {
            producerJobs.add(new SimpleProducerJob(job));
        }
        Gson gson = gsonBuilder.create();
        return gson.toJson(producerJobs);
    }
}

