/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import java.util.Collection;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gobblin.ingestion.google.webmaster.UrlTrieNode;

public class UrlTrie {
    private final UrlTrieNode _root;
    private final String _prefix;

    public UrlTrie(String rootPage, Collection<String> pages) {
        Pair<String, UrlTrieNode> defaults = this.getPrefixAndDefaultRoot(rootPage);
        this._prefix = (String)defaults.getLeft();
        this._root = (UrlTrieNode)defaults.getRight();
        for (String page : pages) {
            this.add(page);
        }
    }

    public UrlTrie(String rootPage, UrlTrieNode root) {
        Pair<String, UrlTrieNode> defaults = this.getPrefixAndDefaultRoot(rootPage);
        this._prefix = (String)defaults.getLeft();
        this._root = root;
    }

    private Pair<String, UrlTrieNode> getPrefixAndDefaultRoot(String rootPage) {
        if (rootPage == null || rootPage.isEmpty()) {
            return Pair.of(null, (Object)new UrlTrieNode(null));
        }
        String prefix = rootPage.substring(0, rootPage.length() - 1);
        Character lastChar = Character.valueOf(rootPage.charAt(rootPage.length() - 1));
        return Pair.of((Object)prefix, (Object)new UrlTrieNode(lastChar));
    }

    public void add(String page) {
        if (this._prefix == null || this._prefix.isEmpty()) {
            this._root.add(page);
        } else {
            if (!page.startsWith(this._prefix)) {
                throw new IllegalArgumentException(String.format("Found a page '%s' not starting with the root page '%s'", page, this._prefix));
            }
            this._root.add(page.substring(this._prefix.length() + 1));
        }
    }

    public UrlTrieNode getChild(String path) {
        return this._root.getChild(path);
    }

    public UrlTrieNode getRoot() {
        return this._root;
    }

    public String getPrefix() {
        return this._prefix;
    }
}

