/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.yarn;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.Service;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.gobblin.cluster.GobblinTaskRunner;
import org.apache.gobblin.cluster.HelixMessageSubTypes;
import org.apache.gobblin.util.JvmUtils;
import org.apache.gobblin.util.logs.Log4jConfigurationHelper;
import org.apache.gobblin.yarn.YarnContainerSecurityManager;
import org.apache.gobblin.yarn.event.DelegationTokenUpdatedEvent;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GobblinYarnTaskRunner
extends GobblinTaskRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(GobblinTaskRunner.class);

    public GobblinYarnTaskRunner(String applicationName, String helixInstanceName, ContainerId containerId, Config config, Optional<Path> appWorkDirOptional) throws Exception {
        super(applicationName, helixInstanceName, GobblinYarnTaskRunner.getApplicationId(containerId), GobblinYarnTaskRunner.getTaskRunnerId(containerId), config, appWorkDirOptional);
    }

    public List<Service> getServices() {
        ArrayList<Service> services = new ArrayList<Service>();
        if (this.config.hasPath("gobblin.yarn.keytab.file.path")) {
            LOGGER.info("Adding YarnContainerSecurityManager since login is keytab based");
            services.add((Service)new YarnContainerSecurityManager(this.config, this.fs, this.eventBus));
        }
        return services;
    }

    public MessageHandlerFactory getUserDefinedMessageHandlerFactory() {
        return new ParticipantUserDefinedMessageHandlerFactory();
    }

    private static String getApplicationId(ContainerId containerId) {
        return containerId.getApplicationAttemptId().getApplicationId().toString();
    }

    private static String getTaskRunnerId(ContainerId containerId) {
        return containerId.toString();
    }

    public static void main(String[] args) throws Exception {
        Options options = GobblinYarnTaskRunner.buildOptions();
        try {
            CommandLine cmd = new DefaultParser().parse(options, args);
            if (!cmd.hasOption("app_name") || !cmd.hasOption("helix_instance_name")) {
                GobblinYarnTaskRunner.printUsage((Options)options);
                System.exit(1);
            }
            Log4jConfigurationHelper.updateLog4jConfiguration(GobblinTaskRunner.class, (String)"log4j-yarn.properties", (String)"log4j-yarn.properties");
            LOGGER.info(JvmUtils.getJvmInputArguments());
            ContainerId containerId = ConverterUtils.toContainerId((String)System.getenv().get(ApplicationConstants.Environment.CONTAINER_ID.key()));
            String applicationName = cmd.getOptionValue("app_name");
            String helixInstanceName = cmd.getOptionValue("helix_instance_name");
            GobblinYarnTaskRunner gobblinTaskRunner = new GobblinYarnTaskRunner(applicationName, helixInstanceName, containerId, ConfigFactory.load(), (Optional<Path>)Optional.absent());
            gobblinTaskRunner.start();
        }
        catch (ParseException pe) {
            GobblinYarnTaskRunner.printUsage((Options)options);
            System.exit(1);
        }
    }

    private class ParticipantUserDefinedMessageHandlerFactory
    implements MessageHandlerFactory {
        private ParticipantUserDefinedMessageHandlerFactory() {
        }

        public MessageHandler createHandler(Message message, NotificationContext context) {
            return new ParticipantUserDefinedMessageHandler(message, context);
        }

        public String getMessageType() {
            return Message.MessageType.USER_DEFINE_MSG.toString();
        }

        public List<String> getMessageTypes() {
            return Collections.singletonList(this.getMessageType());
        }

        public void reset() {
        }

        private class ParticipantUserDefinedMessageHandler
        extends MessageHandler {
            public ParticipantUserDefinedMessageHandler(Message message, NotificationContext context) {
                super(message, context);
            }

            public HelixTaskResult handleMessage() throws InterruptedException {
                String messageSubType = this._message.getMsgSubType();
                if (messageSubType.equalsIgnoreCase(HelixMessageSubTypes.TOKEN_FILE_UPDATED.toString())) {
                    LOGGER.info("Handling message " + HelixMessageSubTypes.TOKEN_FILE_UPDATED.toString());
                    GobblinYarnTaskRunner.this.eventBus.post((Object)new DelegationTokenUpdatedEvent());
                    HelixTaskResult helixTaskResult = new HelixTaskResult();
                    helixTaskResult.setSuccess(true);
                    return helixTaskResult;
                }
                throw new IllegalArgumentException(String.format("Unknown %s message subtype: %s", Message.MessageType.USER_DEFINE_MSG.toString(), messageSubType));
            }

            public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
                LOGGER.error(String.format("Failed to handle message with exception %s, error code %s, error type %s", e, code, type));
            }
        }
    }
}

