/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.restli;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.linkedin.r2.filter.FilterChain;
import com.linkedin.r2.filter.FilterChains;
import com.linkedin.r2.filter.compression.EncodingType;
import com.linkedin.r2.filter.compression.ServerCompressionFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.transport.common.RestRequestHandler;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import com.linkedin.r2.transport.http.server.HttpNettyServerFactory;
import com.linkedin.r2.transport.http.server.HttpServer;
import com.linkedin.restli.docgen.DefaultDocumentationRequestHandler;
import com.linkedin.restli.server.DelegatingTransportDispatcher;
import com.linkedin.restli.server.RestLiConfig;
import com.linkedin.restli.server.RestLiDocumentationRequestHandler;
import com.linkedin.restli.server.RestLiServer;
import com.linkedin.restli.server.filter.Filter;
import com.linkedin.restli.server.guice.GuiceInjectResourceFactory;
import com.linkedin.restli.server.resources.BaseResource;
import com.linkedin.restli.server.resources.ResourceFactory;
import com.linkedin.restli.server.validation.RestLiValidationFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedRestliServer
extends AbstractIdleService {
    private static final int MAX_PORT = 65535;
    private static final int MIN_PORT = 1024;
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedRestliServer.class);
    private final URI serverUri;
    private final int port;
    private final Injector injector;
    private final Logger log;
    private final String name;
    private final Collection<Class<? extends BaseResource>> resources;
    private volatile Optional<HttpServer> httpServer;

    public EmbeddedRestliServer(URI serverUri, int port, Injector injector, Logger log, String name, Collection<Class<? extends BaseResource>> resources) {
        this.resources = resources;
        if (this.resources.isEmpty()) {
            throw new RuntimeException("No resources specified for embedded server.");
        }
        try {
            this.serverUri = serverUri == null ? new URI("http://localhost") : serverUri;
        }
        catch (URISyntaxException use) {
            throw new RuntimeException("Invalid URI. This is an error in code.", use);
        }
        this.port = this.computePort(port, this.serverUri);
        this.injector = injector == null ? Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
            }
        }}) : injector;
        this.log = log == null ? LOGGER : log;
        this.name = Strings.isNullOrEmpty((String)name) ? this.resources.iterator().next().getSimpleName() : name;
    }

    private final int computePort(int port, URI uri) {
        if (port > 0) {
            return port;
        }
        if (uri.getPort() > 0) {
            return uri.getPort();
        }
        return new Random().nextInt(64512) + 1024;
    }

    protected void startUp() throws Exception {
        RestLiConfig config = new RestLiConfig();
        HashSet resourceClassNames = Sets.newHashSet();
        for (Class<? extends BaseResource> resClass : this.resources) {
            resourceClassNames.add(resClass.getName());
        }
        config.addResourceClassNames((Collection)resourceClassNames);
        config.setServerNodeUri(this.serverUri);
        config.setDocumentationRequestHandler((RestLiDocumentationRequestHandler)new DefaultDocumentationRequestHandler());
        config.addFilter(new Filter[]{new RestLiValidationFilter()});
        GuiceInjectResourceFactory factory = new GuiceInjectResourceFactory(this.injector);
        DelegatingTransportDispatcher dispatcher = new DelegatingTransportDispatcher((RestRequestHandler)new RestLiServer(config, (ResourceFactory)factory));
        String acceptedFilters = EncodingType.SNAPPY.getHttpName() + "," + EncodingType.GZIP.getHttpName();
        FilterChain filterChain = FilterChains.createRestChain((RestFilter[])new RestFilter[]{new ServerCompressionFilter(acceptedFilters)});
        this.httpServer = Optional.of((Object)new HttpNettyServerFactory(filterChain).createServer(this.port, (TransportDispatcher)dispatcher));
        this.log.info("Starting the {} embedded server at port {}.", (Object)this.name, (Object)this.port);
        ((HttpServer)this.httpServer.get()).start();
    }

    protected void shutDown() throws Exception {
        if (this.httpServer.isPresent()) {
            this.log.info("Stopping the {} embedded server at port {}", (Object)this.name, (Object)this.port);
            ((HttpServer)this.httpServer.get()).stop();
            ((HttpServer)this.httpServer.get()).waitForStop();
        }
    }

    public URI getListeningURI() {
        try {
            return new URI(this.serverUri.getScheme(), this.serverUri.getUserInfo(), this.serverUri.getHost(), this.port, null, null, null);
        }
        catch (URISyntaxException use) {
            throw new RuntimeException("Invalid URI. This is an error in code.", use);
        }
    }

    public String getURIPrefix() {
        return this.getListeningURI().toString() + "/";
    }

    public static EmbeddedRestliServerBuilder builder() {
        return new EmbeddedRestliServerBuilder();
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    public int getPort() {
        return this.port;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public String getName() {
        return this.name;
    }

    public static class EmbeddedRestliServerBuilder {
        private URI serverUri;
        private int port;
        private Injector injector;
        private Logger log;
        private String name;
        private Collection<Class<? extends BaseResource>> resources;

        EmbeddedRestliServerBuilder() {
        }

        public EmbeddedRestliServerBuilder serverUri(URI serverUri) {
            this.serverUri = serverUri;
            return this;
        }

        public EmbeddedRestliServerBuilder port(int port) {
            this.port = port;
            return this;
        }

        public EmbeddedRestliServerBuilder injector(Injector injector) {
            this.injector = injector;
            return this;
        }

        public EmbeddedRestliServerBuilder log(Logger log) {
            this.log = log;
            return this;
        }

        public EmbeddedRestliServerBuilder name(String name) {
            this.name = name;
            return this;
        }

        public EmbeddedRestliServerBuilder resources(Collection<Class<? extends BaseResource>> resources) {
            this.resources = resources;
            return this;
        }

        public EmbeddedRestliServer build() {
            return new EmbeddedRestliServer(this.serverUri, this.port, this.injector, this.log, this.name, this.resources);
        }

        public String toString() {
            return "EmbeddedRestliServer.EmbeddedRestliServerBuilder(serverUri=" + this.serverUri + ", port=" + this.port + ", injector=" + this.injector + ", log=" + this.log + ", name=" + this.name + ", resources=" + this.resources + ")";
        }
    }
}

