/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.caprep.db;

import com.linkedin.r2.caprep.db.DbSink;
import com.linkedin.r2.caprep.db.MessageSerializer;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class FixedFileDbSink
implements DbSink {
    private final File _requestFile;
    private final File _responseFile;
    private final MessageSerializer _serializer;

    public FixedFileDbSink(File requestFile, File responseFile, MessageSerializer serializer) throws IOException {
        this._requestFile = requestFile;
        this._responseFile = responseFile;
        this._serializer = serializer;
    }

    @Override
    public void record(RestRequest req, RestResponse res) throws IOException {
        this.writeRequest(req, this._requestFile);
        this.writeResponse(res, this._responseFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequest(RestRequest req, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this._serializer.writeRequest(out, req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(RestResponse res, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this._serializer.writeResponse(out, res);
        }
    }
}

