/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter;

import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FilterChainIterator<F, REQ extends Request, RES extends Response>
implements NextFilter<REQ, RES> {
    private static final Logger LOG = LoggerFactory.getLogger(FilterChainIterator.class);
    private final List<F> _filters;
    private int _cursor;

    protected FilterChainIterator(List<F> filters, int cursor) {
        this._filters = filters;
        this._cursor = cursor;
    }

    @Override
    public void onRequest(REQ req, RequestContext requestContext, Map<String, String> wireAttrs) {
        if (this._cursor < this._filters.size()) {
            try {
                this.doOnRequest(this._filters.get(this._cursor++), req, requestContext, wireAttrs, this);
            }
            catch (RuntimeException e) {
                this.onError(e, requestContext, wireAttrs);
            }
        }
    }

    @Override
    public void onResponse(RES res, RequestContext requestContext, Map<String, String> wireAttrs) {
        if (this._cursor > 0) {
            try {
                this.doOnResponse(this._filters.get(--this._cursor), res, requestContext, wireAttrs, this);
            }
            catch (RuntimeException e) {
                if (this._cursor == 0) {
                    LOG.error("Uncaught exception from the last response filter in the filter chain: " + this.getLastFilterName(), (Throwable)e);
                }
                this.onError(e, requestContext, wireAttrs);
            }
        }
    }

    private String getLastFilterName() {
        return this._filters != null && this._filters.size() > 0 ? this._filters.get(0).getClass().getName() : "";
    }

    @Override
    public void onError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs) {
        if (this._cursor > 0) {
            try {
                this.doOnError(this._filters.get(--this._cursor), ex, requestContext, wireAttrs, this);
            }
            catch (RuntimeException e) {
                if (this._cursor == 0) {
                    LOG.error("Uncaught exception from the last error filter in the filter chain: " + this.getLastFilterName(), (Throwable)e);
                }
                this.onError(e, requestContext, wireAttrs);
            }
        }
    }

    protected abstract void doOnRequest(F var1, REQ var2, RequestContext var3, Map<String, String> var4, NextFilter<REQ, RES> var5);

    protected abstract void doOnResponse(F var1, RES var2, RequestContext var3, Map<String, String> var4, NextFilter<REQ, RES> var5);

    protected abstract void doOnError(F var1, Throwable var2, RequestContext var3, Map<String, String> var4, NextFilter<REQ, RES> var5);

    static class FilterChainStreamIterator
    extends FilterChainIterator<StreamFilter, StreamRequest, StreamResponse> {
        public FilterChainStreamIterator(List<StreamFilter> filters, int cursor) {
            super(filters, cursor);
        }

        @Override
        protected void doOnRequest(StreamFilter filter, StreamRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
            filter.onStreamRequest(req, requestContext, wireAttrs, nextFilter);
        }

        @Override
        protected void doOnResponse(StreamFilter filter, StreamResponse res, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
            filter.onStreamResponse(res, requestContext, wireAttrs, nextFilter);
        }

        @Override
        protected void doOnError(StreamFilter filter, Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
            filter.onStreamError(ex, requestContext, wireAttrs, nextFilter);
        }
    }

    static class FilterChainRestIterator
    extends FilterChainIterator<RestFilter, RestRequest, RestResponse> {
        public FilterChainRestIterator(List<RestFilter> filters, int cursor) {
            super(filters, cursor);
        }

        @Override
        protected void doOnRequest(RestFilter filter, RestRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
            filter.onRestRequest(req, requestContext, wireAttrs, nextFilter);
        }

        @Override
        protected void doOnResponse(RestFilter filter, RestResponse res, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
            filter.onRestResponse(res, requestContext, wireAttrs, nextFilter);
        }

        @Override
        protected void doOnError(RestFilter filter, Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
            filter.onRestError(ex, requestContext, wireAttrs, nextFilter);
        }
    }
}

