/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.transport;

import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.entitystream.BaseConnector;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class DispatcherRequestFilter
implements StreamFilter,
RestFilter {
    private final TransportDispatcher _dispatcher;

    public DispatcherRequestFilter(TransportDispatcher dispatcher) {
        this._dispatcher = dispatcher;
    }

    @Override
    public void onRestRequest(RestRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        try {
            this._dispatcher.handleRestRequest(req, wireAttrs, requestContext, this.createCallback(requestContext, nextFilter));
        }
        catch (Exception e) {
            nextFilter.onError(e, requestContext, new HashMap<String, String>());
        }
    }

    private <REQ extends Request, RES extends Response> TransportCallback<RES> createCallback(final RequestContext requestContext, final NextFilter<REQ, RES> nextFilter) {
        return new TransportCallback<RES>(){

            @Override
            public void onResponse(TransportResponse<RES> res) {
                Map<String, String> wireAttrs = res.getWireAttributes();
                if (res.hasError()) {
                    nextFilter.onError(res.getError(), requestContext, wireAttrs);
                } else {
                    nextFilter.onResponse((Response)res.getResponse(), requestContext, wireAttrs);
                }
            }
        };
    }

    @Override
    public void onStreamRequest(StreamRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        block2: {
            BaseConnector connector = null;
            try {
                AtomicBoolean responded = new AtomicBoolean(false);
                TransportCallback<StreamResponse> callback = this.createStreamCallback(requestContext, nextFilter, responded);
                connector = new Connector(responded, nextFilter, requestContext, wireAttrs);
                req.getEntityStream().setReader(connector);
                EntityStream newStream = EntityStreams.newEntityStream(connector);
                this._dispatcher.handleStreamRequest(req.builder().build(newStream), wireAttrs, requestContext, callback);
            }
            catch (Exception e) {
                nextFilter.onError(e, requestContext, new HashMap<String, String>());
                if (connector == null) break block2;
                connector.cancel();
            }
        }
    }

    private <REQ extends Request, RES extends Response> TransportCallback<RES> createStreamCallback(final RequestContext requestContext, final NextFilter<REQ, RES> nextFilter, final AtomicBoolean responded) {
        return new TransportCallback<RES>(){

            @Override
            public void onResponse(TransportResponse<RES> res) {
                if (responded.compareAndSet(false, true)) {
                    Map<String, String> wireAttrs = res.getWireAttributes();
                    if (res.hasError()) {
                        nextFilter.onError(res.getError(), requestContext, wireAttrs);
                    } else {
                        nextFilter.onResponse((Response)res.getResponse(), requestContext, wireAttrs);
                    }
                }
            }
        };
    }

    private static class Connector
    extends BaseConnector {
        private final AtomicBoolean _responded;
        private final NextFilter<StreamRequest, StreamResponse> _nextFilter;
        private final RequestContext _requestContext;
        private final Map<String, String> _wireAttrs;

        Connector(AtomicBoolean responded, NextFilter<StreamRequest, StreamResponse> nextFilter, RequestContext requestContext, Map<String, String> wireAttrs) {
            this._responded = responded;
            this._nextFilter = nextFilter;
            this._requestContext = requestContext;
            this._wireAttrs = wireAttrs;
        }

        @Override
        public void onAbort(Throwable e) {
            super.onAbort(e);
            if (this._responded.compareAndSet(false, true)) {
                this._nextFilter.onError(e, this._requestContext, this._wireAttrs);
            }
        }
    }
}

