/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message;

import com.linkedin.r2.message.MessageHeaders;
import com.linkedin.r2.message.MessageHeadersBuilder;
import com.linkedin.r2.message.rest.RestUtil;
import com.linkedin.util.ArgumentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class BaseMessageBuilder<B extends BaseMessageBuilder<B>>
implements MessageHeadersBuilder<B> {
    private static final String CANONICAL_REGEX = "[ \t\n\r]+";
    private static final String CANONICAL_REPLACEMENT = " ";
    private Map<String, String> _headers;
    private List<String> _cookies;

    public BaseMessageBuilder() {
        this.setHeaders(Collections.emptyMap());
        this.setCookies(Collections.emptyList());
    }

    public BaseMessageBuilder(MessageHeaders message) {
        this.setHeaders((Map)message.getHeaders());
        this.setCookies((List)message.getCookies());
    }

    @Override
    public B setHeaders(Map<String, String> headers) {
        ArgumentUtil.notNull(headers, (String)"headers");
        this.validateFieldNames(headers.keySet());
        return this.unsafeSetHeaders(headers);
    }

    @Override
    public B setHeader(String name, String value) {
        this.validateFieldName(name);
        return this.unsafeSetHeader(name, value);
    }

    @Override
    public B addHeaderValue(String name, String value) {
        this.validateFieldName(name);
        return this.unsafeAddHeaderValue(name, value);
    }

    @Override
    public B overwriteHeaders(Map<String, String> headers) {
        ArgumentUtil.notNull(headers, (String)"headers");
        this.validateFieldNames(headers.keySet());
        return this.unsafeOverwriteHeaders(headers);
    }

    @Override
    public B addCookie(String cookie) {
        this._cookies.add(cookie);
        return this.thisBuilder();
    }

    @Override
    public B setCookies(List<String> cookies) {
        this._cookies = new ArrayList<String>(cookies);
        return this.thisBuilder();
    }

    @Override
    public B clearHeaders() {
        this._headers.clear();
        return this.thisBuilder();
    }

    @Override
    public B clearCookies() {
        this._cookies.clear();
        return this.thisBuilder();
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this._headers);
    }

    @Override
    public List<String> getCookies() {
        return Collections.unmodifiableList(this._cookies);
    }

    @Override
    public String getHeader(String name) {
        return this._headers.get(name);
    }

    @Override
    public List<String> getHeaderValues(String name) {
        String headerVal = this.getHeader(name);
        if (headerVal == null) {
            return null;
        }
        return RestUtil.getHeaderValues(headerVal);
    }

    public B unsafeSetHeader(String name, String value) {
        this._headers.put(name, value);
        return this.thisBuilder();
    }

    public B unsafeAddHeaderValue(String name, String value) {
        String current = this._headers.get(name);
        if (current == null) {
            this._headers.put(name, value);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(current).append(',').append(value);
            this._headers.put(name, builder.toString());
        }
        return this.thisBuilder();
    }

    public B unsafeSetHeaders(Map<String, String> headers) {
        this._headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        return this.unsafeOverwriteHeaders(headers);
    }

    public B unsafeOverwriteHeaders(Map<String, String> headers) {
        this._headers.putAll(headers);
        return this.thisBuilder();
    }

    protected abstract void validateCookieHeader(String var1);

    private void validateFieldNames(Collection<String> fieldNames) {
        for (String fieldName : fieldNames) {
            this.validateFieldName(fieldName);
        }
    }

    private void validateFieldName(String name) {
        this.validateCookieHeader(name);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("header names must contain at least one character");
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch <= ' ' || ch >= '\u007f') {
                throw new IllegalArgumentException("header name does not conform to RFC 2616, section 2.2: " + name);
            }
            switch (ch) {
                case '\"': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    throw new IllegalArgumentException("header name does not conform to RFC 2616, section 2.2: " + name);
                }
            }
        }
    }

    protected Map<String, String> getCanonicalHeaders() {
        Map<String, String> orig = this.getHeaders();
        HashMap<String, String> headers = new HashMap<String, String>(orig.size());
        for (Map.Entry<String, String> entry : orig.entrySet()) {
            String key = entry.getKey().toLowerCase();
            String value = entry.getValue().trim().replaceAll(CANONICAL_REGEX, CANONICAL_REPLACEMENT);
            headers.put(key, value);
        }
        return Collections.unmodifiableMap(headers);
    }

    protected List<String> getCanonicalCookies() {
        List<String> orig = this.getCookies();
        ArrayList<String> cookies = new ArrayList<String>(orig.size());
        for (String entry : orig) {
            String value = entry.trim().replaceAll(CANONICAL_REGEX, CANONICAL_REPLACEMENT);
            cookies.add(value);
        }
        return Collections.unmodifiableList(cookies);
    }

    protected B thisBuilder() {
        return (B)this;
    }
}

