/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message.rest;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.BaseRequestBuilder;
import com.linkedin.r2.message.rest.RestMessageBuilder;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestImpl;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.util.ArgumentUtil;
import java.net.URI;

public final class RestRequestBuilder
extends BaseRequestBuilder<RestRequestBuilder>
implements RestMessageBuilder<RestRequestBuilder> {
    private ByteString _entity = ByteString.empty();

    public RestRequestBuilder(URI uri) {
        super(uri);
    }

    public RestRequestBuilder(RestRequest request) {
        super(request);
        this._entity = request.getEntity();
    }

    public RestRequestBuilder(StreamRequest request) {
        super(request);
    }

    @Override
    public RestRequestBuilder setEntity(ByteString entity) {
        ArgumentUtil.notNull((Object)entity, (String)"entity");
        this._entity = entity;
        return this;
    }

    @Override
    public RestRequestBuilder setEntity(byte[] entity) {
        ArgumentUtil.notNull((Object)entity, (String)"entity");
        this._entity = ByteString.copy((byte[])entity);
        return this;
    }

    @Override
    public ByteString getEntity() {
        return this._entity;
    }

    @Override
    public RestRequest build() {
        return new RestRequestImpl(this._entity, this.getHeaders(), this.getCookies(), this.getURI(), this.getMethod());
    }

    @Override
    public RestRequest buildCanonical() {
        return new RestRequestImpl(this._entity, this.getCanonicalHeaders(), this.getCanonicalCookies(), this.getURI(), this.getMethod());
    }
}

