/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message.rest;

import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import java.nio.charset.Charset;

public class RestStatus {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static int OK = 200;
    public static int MOVED_PERMANENTLY = 301;
    public static int FOUND = 302;
    public static int SEE_OTHER = 303;
    public static int TEMPORARY_REDIRECT = 307;
    public static int BAD_REQUEST = 400;
    public static int NOT_FOUND = 404;
    public static int INTERNAL_SERVER_ERROR = 500;

    public static boolean isOK(int status) {
        return status >= 200 && status < 300;
    }

    public static boolean isClientError(int status) {
        return status >= 400 && status < 500;
    }

    public static boolean isServerError(int status) {
        return status >= 500 && status < 600;
    }

    public static RestResponse responseForError(int status, Throwable e) {
        return RestStatus.responseForStatus(status, e.toString());
    }

    public static RestResponse responseForStatus(int status, String detail) {
        if (detail == null) {
            detail = "No detailed message";
        }
        return ((RestResponseBuilder)((RestResponseBuilder)new RestResponseBuilder().setStatus(status)).setEntity(detail.getBytes(UTF8)).setHeader("Content-Type", "text/plain")).build();
    }

    private RestStatus() {
    }
}

