/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message.stream;

import com.linkedin.r2.message.BaseRequest;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import java.net.URI;
import java.util.List;
import java.util.Map;

final class StreamRequestImpl
extends BaseRequest
implements StreamRequest {
    private final EntityStream _entityStream;

    StreamRequestImpl(EntityStream entityStream, Map<String, String> headers, List<String> cookies, URI uri, String method) {
        super(headers, cookies, uri, method);
        this._entityStream = entityStream;
    }

    @Override
    public StreamRequestBuilder builder() {
        return new StreamRequestBuilder(this);
    }

    @Override
    public EntityStream getEntityStream() {
        return this._entityStream;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamRequestImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this._entityStream == ((StreamRequestImpl)o)._entityStream;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return 31 * result + this._entityStream.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StreamRequest[headers=").append(this.getHeaders()).append("cookies=").append(this.getCookies()).append(",uri=").append(this.getURI()).append(",method=").append(this.getMethod()).append("]");
        return builder.toString();
    }
}

