/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.common.bridge.server;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestStatus;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.entitystream.DrainReader;
import com.linkedin.r2.transport.common.RestRequestHandler;
import com.linkedin.r2.transport.common.StreamRequestHandler;
import com.linkedin.r2.transport.common.StreamRequestHandlerAdapter;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.common.bridge.server.TransportCallbackAdapter;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import com.linkedin.r2.util.URIUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class ContextDispatcher
implements TransportDispatcher {
    private static final StreamRequestHandler DEFAULT_STREAM_HANDLER = new StreamRequestHandler(){

        @Override
        public void handleRequest(StreamRequest req, RequestContext requestContext, Callback<StreamResponse> callback) {
            RestResponse response = RestStatus.responseForStatus(RestStatus.NOT_FOUND, "No resource for URI: " + req.getURI());
            callback.onSuccess((Object)Messages.toStreamResponse(response));
            req.getEntityStream().setReader(new DrainReader());
        }
    };
    private static final RestRequestHandler DEFAULT_REST_HANDLER = new RestRequestHandler(){

        @Override
        public void handleRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
            callback.onSuccess((Object)RestStatus.responseForStatus(RestStatus.NOT_FOUND, "No resource for URI: " + request.getURI()));
        }
    };
    private final Map<String, StreamRequestHandler> _streamHandlers = new HashMap<String, StreamRequestHandler>();
    private final Map<String, RestRequestHandler> _restHandlers;

    public ContextDispatcher(Map<String, RestRequestHandler> restDispatcher) {
        for (Map.Entry<String, RestRequestHandler> entry : restDispatcher.entrySet()) {
            this._streamHandlers.put(entry.getKey(), new StreamRequestHandlerAdapter(entry.getValue()));
        }
        this._restHandlers = new HashMap<String, RestRequestHandler>(restDispatcher);
    }

    @Override
    public void handleRestRequest(RestRequest req, Map<String, String> wireAttrs, RequestContext requestContext, TransportCallback<RestResponse> callback) {
        RestRequestHandler handler = this.getHandler(req.getURI(), this._restHandlers, DEFAULT_REST_HANDLER);
        try {
            handler.handleRequest(req, requestContext, new TransportCallbackAdapter<RestResponse>(callback));
        }
        catch (Exception e) {
            callback.onResponse(TransportResponseImpl.error(RestException.forError(RestStatus.INTERNAL_SERVER_ERROR, e)));
        }
    }

    @Override
    public void handleStreamRequest(StreamRequest req, Map<String, String> wireAttrs, RequestContext requestContext, TransportCallback<StreamResponse> callback) {
        StreamRequestHandler handler = this.getHandler(req.getURI(), this._streamHandlers, DEFAULT_STREAM_HANDLER);
        try {
            handler.handleRequest(req, requestContext, new TransportCallbackAdapter<StreamResponse>(callback));
        }
        catch (Exception e) {
            RestException ex = RestException.forError(RestStatus.INTERNAL_SERVER_ERROR, e);
            callback.onResponse(TransportResponseImpl.error(ex));
        }
    }

    private <T> T getHandler(URI uri, Map<String, T> handlers, T defaultHandler) {
        String path = uri.getPath();
        if (path == null) {
            return defaultHandler;
        }
        String[] segs = URIUtil.tokenizePath(path);
        if (segs.length < 1) {
            return defaultHandler;
        }
        T handler = handlers.get(segs[0]);
        return handler != null ? handler : defaultHandler;
    }
}

