/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.callback.SimpleCallback;
import com.linkedin.r2.transport.http.client.RateLimiter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExponentialBackOffRateLimiter
implements RateLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(ExponentialBackOffRateLimiter.class);
    private final ScheduledExecutorService _executor;
    private final long _minPeriod;
    private final long _initialIncrement;
    private final long _maxPeriod;
    private final int _maxRunningTasks;
    private final Queue<RateLimiter.Task> _pending = new LinkedList<RateLimiter.Task>();
    private long _period;
    private int _runningTasks;
    private ScheduledFuture<?> _task;
    private final SimpleCallback _doneCallback = new SimpleCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDone() {
            ExponentialBackOffRateLimiter exponentialBackOffRateLimiter = ExponentialBackOffRateLimiter.this;
            synchronized (exponentialBackOffRateLimiter) {
                ExponentialBackOffRateLimiter.this._runningTasks--;
                ExponentialBackOffRateLimiter.this.schedule();
            }
        }
    };
    private final Runnable _doit = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RateLimiter.Task t = null;
            ExponentialBackOffRateLimiter exponentialBackOffRateLimiter = ExponentialBackOffRateLimiter.this;
            synchronized (exponentialBackOffRateLimiter) {
                ExponentialBackOffRateLimiter.this._task = null;
                if (ExponentialBackOffRateLimiter.this._runningTasks < ExponentialBackOffRateLimiter.this._maxRunningTasks && !ExponentialBackOffRateLimiter.this._pending.isEmpty()) {
                    ExponentialBackOffRateLimiter.this._runningTasks++;
                    t = (RateLimiter.Task)ExponentialBackOffRateLimiter.this._pending.poll();
                }
                ExponentialBackOffRateLimiter.this.schedule();
            }
            if (t != null) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Running rate limited task at {} with period {}", (Object)System.currentTimeMillis(), (Object)ExponentialBackOffRateLimiter.this._period);
                    }
                    t.run(ExponentialBackOffRateLimiter.this._doneCallback);
                }
                catch (Exception e) {
                    LOG.error("Uncaught exception while running rate-limited task", (Throwable)e);
                }
            }
        }
    };

    public ExponentialBackOffRateLimiter(long minPeriod, long maxPeriod, long initialIncrement, ScheduledExecutorService executor) {
        this(minPeriod, maxPeriod, initialIncrement, executor, Integer.MAX_VALUE);
    }

    public ExponentialBackOffRateLimiter(long minPeriod, long maxPeriod, long initialIncrement, ScheduledExecutorService executor, int maxRunningTasks) {
        this._minPeriod = minPeriod;
        this._maxPeriod = maxPeriod;
        this._initialIncrement = initialIncrement;
        this._executor = executor;
        this._maxRunningTasks = maxRunningTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPeriod(long ms) {
        Long previous = null;
        ms = Math.min(this._maxPeriod, Math.max(this._minPeriod, ms));
        ExponentialBackOffRateLimiter exponentialBackOffRateLimiter = this;
        synchronized (exponentialBackOffRateLimiter) {
            if (ms != this._period) {
                previous = this._period;
                this._period = ms;
                if (!this._pending.isEmpty() && (this._task == null || this._task.cancel(false))) {
                    long adjustedPeriod = this._period;
                    if (this._task != null) {
                        long elapsedTime = previous - this._task.getDelay(TimeUnit.MILLISECONDS);
                        adjustedPeriod = Math.max(this._period - elapsedTime, 0L);
                        this._task = null;
                    }
                    this.schedule(adjustedPeriod);
                }
            }
        }
        if (previous != null) {
            LOG.debug("Minimum period changed from {} to {}", (Object)previous, (Object)ms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementPeriod() {
        ExponentialBackOffRateLimiter exponentialBackOffRateLimiter = this;
        synchronized (exponentialBackOffRateLimiter) {
            this.setPeriod(Math.min(this._maxPeriod, this._period == 0L ? this._initialIncrement : this._period * 2L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(RateLimiter.Task t) {
        boolean runNow = false;
        ExponentialBackOffRateLimiter exponentialBackOffRateLimiter = this;
        synchronized (exponentialBackOffRateLimiter) {
            if (this._period == 0L && this._pending.isEmpty() && this._runningTasks < this._maxRunningTasks) {
                ++this._runningTasks;
                runNow = true;
            } else {
                this._pending.add(t);
                this.schedule();
            }
        }
        if (runNow) {
            t.run(this._doneCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RateLimiter.Task> cancelPendingTasks() {
        ExponentialBackOffRateLimiter exponentialBackOffRateLimiter = this;
        synchronized (exponentialBackOffRateLimiter) {
            RateLimiter.Task item;
            ArrayList<RateLimiter.Task> cancelled = new ArrayList<RateLimiter.Task>(this._pending.size());
            while ((item = this._pending.poll()) != null) {
                cancelled.add(item);
            }
            return cancelled;
        }
    }

    private void schedule() {
        this.schedule(this._period);
    }

    private void schedule(long delay) {
        if (this._runningTasks < this._maxRunningTasks && !this._pending.isEmpty() && this._task == null) {
            this._task = this._executor.schedule(this._doit, delay, TimeUnit.MILLISECONDS);
        }
    }
}

