/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.transport.http.client.AsyncPool;
import com.linkedin.r2.transport.http.client.AsyncPoolHandle;
import com.linkedin.r2.util.Timeout;
import com.linkedin.r2.util.TimeoutExecutor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TimeoutAsyncPoolHandle<T>
implements AsyncPoolHandle<T>,
TimeoutExecutor {
    private final AsyncPool<T> _pool;
    private final Timeout<T> _timeout;
    private volatile boolean _error = false;

    public TimeoutAsyncPoolHandle(AsyncPool<T> pool, ScheduledExecutorService scheduler, long timeout, TimeUnit unit, T item) {
        this._pool = pool;
        this._timeout = new Timeout<T>(scheduler, timeout, unit, item);
        this._timeout.addTimeoutTask(() -> this._pool.dispose(item));
    }

    public TimeoutAsyncPoolHandle<T> error() {
        this._error = true;
        return this;
    }

    @Override
    public void release() {
        T item = this._timeout.getItem();
        if (item == null) {
            return;
        }
        if (this._error) {
            this._pool.dispose(item);
        } else {
            this._pool.put(item);
        }
    }

    @Override
    public AsyncPool<T> pool() {
        return this._pool;
    }

    @Override
    public void addTimeoutTask(Runnable task) {
        this._timeout.addTimeoutTask(task);
    }
}

