/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.util;

import java.util.AbstractQueue;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractDeque<E>
extends AbstractQueue<E>
implements Deque<E> {
    @Override
    public void addFirst(E e) {
        if (!this.offerFirst(e)) {
            throw new IllegalStateException("Queue full");
        }
    }

    @Override
    public void addLast(E e) {
        if (!this.offerLast(e)) {
            throw new IllegalStateException("Queue full");
        }
    }

    @Override
    public E removeFirst() {
        Object e = this.pollFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E removeLast() {
        Object e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E getFirst() {
        Object e = this.peekFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E getLast() {
        Object e = this.peekLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            if (!i.next().equals(o)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        Iterator i = this.descendingIterator();
        while (i.hasNext()) {
            if (!i.next().equals(o)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }
}

