/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Cancellable;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.Exceptions;
import com.linkedin.parseq.FusionTask;
import com.linkedin.parseq.Par2Task;
import com.linkedin.parseq.Par3Task;
import com.linkedin.parseq.Par4Task;
import com.linkedin.parseq.Par5Task;
import com.linkedin.parseq.Par6Task;
import com.linkedin.parseq.Par7Task;
import com.linkedin.parseq.Par8Task;
import com.linkedin.parseq.Par9Task;
import com.linkedin.parseq.Priority;
import com.linkedin.parseq.Tuple2Task;
import com.linkedin.parseq.Tuple3Task;
import com.linkedin.parseq.Tuple4Task;
import com.linkedin.parseq.Tuple5Task;
import com.linkedin.parseq.Tuple6Task;
import com.linkedin.parseq.Tuple7Task;
import com.linkedin.parseq.Tuple8Task;
import com.linkedin.parseq.Tuple9Task;
import com.linkedin.parseq.function.Action;
import com.linkedin.parseq.function.Consumer1;
import com.linkedin.parseq.function.Function1;
import com.linkedin.parseq.function.Try;
import com.linkedin.parseq.internal.ArgumentUtil;
import com.linkedin.parseq.internal.TimeUnitHelper;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.PromisePropagator;
import com.linkedin.parseq.promise.PromiseTransformer;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.parseq.promise.SettablePromise;
import com.linkedin.parseq.retry.RetriableTask;
import com.linkedin.parseq.retry.RetryPolicy;
import com.linkedin.parseq.trace.ShallowTrace;
import com.linkedin.parseq.trace.ShallowTraceBuilder;
import com.linkedin.parseq.trace.Trace;
import com.linkedin.parseq.trace.TraceBuilder;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Task<T>
extends Promise<T>,
Cancellable {
    public static final Logger LOGGER = LoggerFactory.getLogger(Task.class);

    public String getName();

    public int getPriority();

    public boolean setPriority(int var1);

    public void setTraceValueSerializer(Function<T, String> var1);

    public void contextRun(Context var1, Task<?> var2, Collection<Task<?>> var3);

    public ShallowTrace getShallowTrace();

    public Trace getTrace();

    public Long getId();

    public ShallowTraceBuilder getShallowTraceBuilder();

    public TraceBuilder getTraceBuilder();

    default public <R> Task<R> apply(String desc, PromisePropagator<T, R> propagator) {
        return FusionTask.create(desc, this, propagator);
    }

    default public <R> Task<R> map(String desc, Function1<? super T, ? extends R> func) {
        ArgumentUtil.requireNotNull(func, "function");
        return this.apply(desc, new PromiseTransformer<T, R>(func));
    }

    default public <R> Task<R> map(Function1<? super T, ? extends R> func) {
        return this.map("map: " + func.getClass().getName(), func);
    }

    default public <R> Task<R> flatMap(String desc, Function1<? super T, Task<R>> func) {
        ArgumentUtil.requireNotNull(func, "function");
        Task<Task<R>> nested = this.map("map: " + desc, func);
        nested.getShallowTraceBuilder().setSystemHidden(true);
        return Task.flatten(desc, nested);
    }

    default public <R> Task<R> flatMap(Function1<? super T, Task<R>> func) {
        return this.flatMap("flatMap: " + func.getClass().getName(), func);
    }

    default public Task<T> withSideEffect(String desc, Function1<? super T, Task<?>> func) {
        ArgumentUtil.requireNotNull(func, "function");
        Task that = this;
        return Task.async("withSideEffect", (Context context) -> {
            Task sideEffectWrapper = Task.async(desc, (Context ctx) -> {
                SettablePromise promise = Promises.settable();
                if (!that.isFailed()) {
                    Task sideEffect = (Task)func.apply((Object)that.get());
                    ctx.runSideEffect(sideEffect);
                }
                Promises.propagateResult(that, promise);
                return promise;
            });
            context.after(that).run(sideEffectWrapper);
            context.run(that);
            return sideEffectWrapper;
        });
    }

    default public Task<T> withSideEffect(Function1<? super T, Task<?>> func) {
        return this.withSideEffect("sideEffect: " + func.getClass().getName(), func);
    }

    default public Task<T> shareable() {
        Task that = this;
        return Task.async("shareable", (Context context) -> {
            SettablePromise result = Promises.settable();
            context.runSideEffect(that);
            Promises.propagateResult(that, result);
            return result;
        });
    }

    default public Task<T> andThen(String desc, Consumer1<? super T> consumer) {
        ArgumentUtil.requireNotNull(consumer, "consumer");
        return this.apply(desc, new PromiseTransformer<Object, Object>(t -> {
            consumer.accept((Object)t);
            return t;
        }));
    }

    default public Task<T> andThen(Consumer1<? super T> consumer) {
        return this.andThen("andThen: " + consumer.getClass().getName(), consumer);
    }

    default public <R> Task<R> andThen(String desc, Task<R> task) {
        ArgumentUtil.requireNotNull(task, "task");
        Task that = this;
        return Task.async(desc, (Context context) -> {
            SettablePromise result = Promises.settable();
            context.after(that).run(task);
            Promises.propagateResult(task, result);
            context.run(that);
            return result;
        });
    }

    default public <R> Task<R> andThen(Task<R> task) {
        return this.andThen("andThen: " + task.getClass().getName(), task);
    }

    default public Task<T> recover(String desc, Function1<Throwable, T> func) {
        ArgumentUtil.requireNotNull(func, "function");
        return this.apply(desc, (src, dst) -> {
            if (src.isFailed()) {
                if (!Exceptions.isCancellation(src.getError())) {
                    try {
                        dst.done(func.apply(src.getError()));
                    }
                    catch (Throwable t) {
                        dst.fail(t);
                    }
                } else {
                    dst.fail(src.getError());
                }
            } else {
                dst.done(src.get());
            }
        });
    }

    default public Task<T> recover(Function1<Throwable, T> func) {
        return this.recover("recover: " + func.getClass().getName(), func);
    }

    default public Task<T> onFailure(String desc, Consumer1<Throwable> consumer) {
        ArgumentUtil.requireNotNull(consumer, "consumer");
        return this.apply(desc, (src, dst) -> {
            if (src.isFailed()) {
                if (!Exceptions.isCancellation(src.getError())) {
                    try {
                        consumer.accept(src.getError());
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception thrown by onFailure consumer: ", (Throwable)e);
                    }
                    finally {
                        dst.fail(src.getError());
                    }
                } else {
                    dst.fail(src.getError());
                }
            } else {
                dst.done(src.get());
            }
        });
    }

    default public Task<T> onFailure(Consumer1<Throwable> consumer) {
        return this.onFailure("onFailure: " + consumer.getClass().getName(), consumer);
    }

    default public Task<Try<T>> toTry(String desc) {
        return this.apply(desc, (src, dst) -> {
            Try tryT = Promises.toTry(src);
            if (tryT.isFailed() && Exceptions.isCancellation(tryT.getError())) {
                dst.fail(src.getError());
            } else {
                dst.done(Promises.toTry(src));
            }
        });
    }

    default public Task<Try<T>> toTry() {
        return this.toTry("toTry");
    }

    default public <R> Task<R> transform(String desc, Function1<Try<T>, Try<R>> func) {
        ArgumentUtil.requireNotNull(func, "function");
        return this.apply(desc, (src, dst) -> {
            Try tryT = Promises.toTry(src);
            if (tryT.isFailed() && Exceptions.isCancellation(tryT.getError())) {
                dst.fail(src.getError());
            } else {
                try {
                    Try tryR = (Try)func.apply(tryT);
                    if (tryR.isFailed()) {
                        dst.fail(tryR.getError());
                    } else {
                        dst.done(tryR.get());
                    }
                }
                catch (Exception e) {
                    dst.fail(e);
                }
            }
        });
    }

    default public <R> Task<R> transform(Function1<Try<T>, Try<R>> func) {
        return this.transform("transform: " + func.getClass().getName(), func);
    }

    default public Task<T> recoverWith(String desc, Function1<Throwable, Task<T>> func) {
        ArgumentUtil.requireNotNull(func, "function");
        Task that = this;
        return Task.async(desc, (Context context) -> {
            SettablePromise result = Promises.settable();
            Task recovery = Task.async("recovery", (Context ctx) -> {
                SettablePromise recoveryResult = Promises.settable();
                if (that.isFailed()) {
                    if (!Exceptions.isCancellation(that.getError())) {
                        try {
                            Task r = (Task)func.apply(that.getError());
                            Promises.propagateResult(r, recoveryResult);
                            ctx.run(r);
                        }
                        catch (Throwable t) {
                            recoveryResult.fail(t);
                        }
                    } else {
                        recoveryResult.fail(that.getError());
                    }
                } else {
                    recoveryResult.done(that.get());
                }
                return recoveryResult;
            });
            recovery.getShallowTraceBuilder().setSystemHidden(true);
            Promises.propagateResult(recovery, result);
            context.after(that).run(recovery);
            context.run(that);
            return result;
        });
    }

    default public Task<T> recoverWith(Function1<Throwable, Task<T>> func) {
        return this.recoverWith("recoverWith: " + func.getClass().getName(), func);
    }

    default public Task<T> withTimeout(long time, TimeUnit unit) {
        return this.withTimeout(null, time, unit);
    }

    default public Task<T> withTimeout(String desc, long time, TimeUnit unit) {
        Task that = this;
        String taskName = "withTimeout " + time + TimeUnitHelper.toString(unit) + (desc != null ? " " + desc : "");
        Task<T> withTimeout = Task.async(taskName, (Context ctx) -> {
            AtomicBoolean committed = new AtomicBoolean();
            SettablePromise result = Promises.settable();
            Task<Void> timeoutTask = Task.action("timeout", () -> {
                if (committed.compareAndSet(false, true)) {
                    result.fail(Exceptions.timeoutException(taskName));
                }
            });
            timeoutTask.setPriority(Priority.MAX_PRIORITY);
            ctx.createTimer(time, unit, timeoutTask);
            that.addListener(p -> {
                if (committed.compareAndSet(false, true)) {
                    Promises.propagateResult(that, result);
                }
            });
            that.setPriority(Priority.MAX_PRIORITY);
            ctx.run(that);
            return result;
        });
        withTimeout.setPriority(this.getPriority());
        return withTimeout;
    }

    public static <R> Task<R> flatten(String desc, Task<Task<R>> task) {
        ArgumentUtil.requireNotNull(task, "task");
        return Task.async(desc, (Context context) -> {
            SettablePromise result = Promises.settable();
            context.after(task).run(() -> {
                try {
                    if (!task.isFailed()) {
                        Task t = (Task)task.get();
                        Promises.propagateResult(t, result);
                        return t;
                    }
                    result.fail(task.getError());
                }
                catch (Throwable t) {
                    result.fail(t);
                }
                return null;
            });
            context.run(task);
            return result;
        });
    }

    public static <R> Task<R> flatten(Task<Task<R>> task) {
        return Task.flatten("flatten", task);
    }

    public static Task<Void> action(String desc, Action action) {
        ArgumentUtil.requireNotNull(action, "action");
        return Task.async(desc, () -> {
            action.run();
            return Promises.VOID;
        });
    }

    public static Task<Void> action(Action action) {
        return Task.action("action: " + action.getClass().getName(), action);
    }

    public static <T> Task<T> value(String desc, T value) {
        return FusionTask.create(desc, (src, dst) -> dst.done(value));
    }

    public static <T> Task<T> value(T value) {
        return Task.value("value", value);
    }

    public static <T> Task<T> failure(String desc, Throwable failure) {
        ArgumentUtil.requireNotNull(failure, "failure");
        return FusionTask.create(desc, (src, dst) -> dst.fail(failure));
    }

    public static <T> Task<T> failure(Throwable failure) {
        return Task.failure("failure", failure);
    }

    public static <T> Task<T> callable(String name, Callable<? extends T> callable) {
        ArgumentUtil.requireNotNull(callable, "callable");
        return FusionTask.create(name, (src, dst) -> {
            try {
                dst.done(callable.call());
            }
            catch (Throwable t) {
                dst.fail(t);
            }
        });
    }

    public static <T> Task<T> callable(Callable<? extends T> callable) {
        return Task.callable("callable: " + callable.getClass().getName(), callable);
    }

    public static <T> Task<T> async(String name, Callable<Promise<? extends T>> callable) {
        ArgumentUtil.requireNotNull(callable, "callable");
        return Task.async(name, (Context context) -> {
            try {
                return (Promise)callable.call();
            }
            catch (Throwable e) {
                return Promises.error(e);
            }
        });
    }

    public static <T> Task<T> async(Callable<Promise<? extends T>> callable) {
        return Task.async("async: " + callable.getClass().getName(), callable);
    }

    public static <T> Task<T> async(String name, final Function1<Context, Promise<? extends T>> func) {
        ArgumentUtil.requireNotNull(func, "function");
        BaseTask task = new BaseTask<T>(name){

            @Override
            protected Promise<? extends T> run(Context context) throws Throwable {
                return (Promise)func.apply(context);
            }
        };
        return task;
    }

    public static <T> Task<T> async(Function1<Context, Promise<? extends T>> func) {
        return Task.async("async: " + func.getClass().getName(), func);
    }

    public static <T> Task<T> blocking(String name, Callable<? extends T> callable, Executor executor) {
        ArgumentUtil.requireNotNull(callable, "callable");
        ArgumentUtil.requireNotNull(callable, "executor");
        return Task.async(name, () -> {
            SettablePromise promise = Promises.settable();
            executor.execute(() -> {
                try {
                    promise.done(callable.call());
                }
                catch (Throwable t) {
                    promise.fail(t);
                }
            });
            return promise;
        });
    }

    public static <T> Task<T> blocking(Callable<? extends T> callable, Executor executor) {
        return Task.blocking("blocking: " + callable.getClass().getName(), callable, executor);
    }

    public static <T1, T2> Tuple2Task<T1, T2> par(Task<T1> task1, Task<T2> task2) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        return new Par2Task<T1, T2>("par2", task1, task2);
    }

    public static <T1, T2, T3> Tuple3Task<T1, T2, T3> par(Task<T1> task1, Task<T2> task2, Task<T3> task3) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        return new Par3Task<T1, T2, T3>("par3", task1, task2, task3);
    }

    public static <T1, T2, T3, T4> Tuple4Task<T1, T2, T3, T4> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        return new Par4Task<T1, T2, T3, T4>("par4", task1, task2, task3, task4);
    }

    public static <T1, T2, T3, T4, T5> Tuple5Task<T1, T2, T3, T4, T5> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        return new Par5Task<T1, T2, T3, T4, T5>("par5", task1, task2, task3, task4, task5);
    }

    public static <T1, T2, T3, T4, T5, T6> Tuple6Task<T1, T2, T3, T4, T5, T6> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        return new Par6Task<T1, T2, T3, T4, T5, T6>("par6", task1, task2, task3, task4, task5, task6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Tuple7Task<T1, T2, T3, T4, T5, T6, T7> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6, Task<T7> task7) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        ArgumentUtil.requireNotNull(task7, "task7");
        return new Par7Task<T1, T2, T3, T4, T5, T6, T7>("par7", task1, task2, task3, task4, task5, task6, task7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Tuple8Task<T1, T2, T3, T4, T5, T6, T7, T8> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6, Task<T7> task7, Task<T8> task8) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        ArgumentUtil.requireNotNull(task7, "task7");
        ArgumentUtil.requireNotNull(task8, "task8");
        return new Par8Task<T1, T2, T3, T4, T5, T6, T7, T8>("par8", task1, task2, task3, task4, task5, task6, task7, task8);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Tuple9Task<T1, T2, T3, T4, T5, T6, T7, T8, T9> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6, Task<T7> task7, Task<T8> task8, Task<T9> task9) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        ArgumentUtil.requireNotNull(task7, "task7");
        ArgumentUtil.requireNotNull(task8, "task8");
        ArgumentUtil.requireNotNull(task9, "task9");
        return new Par9Task<T1, T2, T3, T4, T5, T6, T7, T8, T9>("par9", task1, task2, task3, task4, task5, task6, task7, task8, task9);
    }

    public static <T> Task<T> withRetryPolicy(RetryPolicy policy, Callable<Task<T>> taskSupplier) {
        return Task.withRetryPolicy("operation", policy, taskSupplier);
    }

    public static <T> Task<T> withRetryPolicy(RetryPolicy policy, Function1<Integer, Task<T>> taskSupplier) {
        return Task.withRetryPolicy("operation", policy, taskSupplier);
    }

    public static <T> Task<T> withRetryPolicy(String name, RetryPolicy policy, Callable<Task<T>> taskSupplier) {
        return Task.withRetryPolicy(name, policy, (Integer attempt) -> (Task)taskSupplier.call());
    }

    public static <T> Task<T> withRetryPolicy(String name, RetryPolicy policy, Function1<Integer, Task<T>> taskSupplier) {
        return RetriableTask.withRetryPolicy(name, policy, taskSupplier);
    }
}

