/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.internal;

import com.linkedin.parseq.Exceptions;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.trace.ResultType;
import com.linkedin.parseq.trace.ShallowTrace;
import java.util.function.Function;
import org.slf4j.Logger;

public class TaskLogger {
    private static final String START_TASK_FORMAT = "[plan={}]: Starting task '{}'";
    private static final String END_TASK_DEBUG_FORMAT = "[plan={}]: Ending task '{}'. Elapsed: {}ms, Result type: {}.";
    private static final String END_TASK_TRACE_FORMAT = "[plan={}]: Ending task '{}'. Elapsed: {}ms, Result type: {}. Value: {}.";
    private final Long _rootId;
    private final Logger _allLogger;
    private final Logger _rootLogger;
    private final Logger _planLogger;
    private final Long _planId;

    public TaskLogger(Long planId, Long rootId, Logger allLogger, Logger rootLogger, Logger planLogger) {
        this._allLogger = allLogger;
        this._rootLogger = rootLogger;
        this._planLogger = planLogger;
        this._rootId = rootId;
        this._planId = planId;
    }

    public void logTaskStart(Task<?> task) {
        if (this._planLogger.isDebugEnabled()) {
            this._planLogger.debug(START_TASK_FORMAT, (Object)this._planId, (Object)task.getName());
        } else if (this._rootLogger.isDebugEnabled() && this._rootId.equals(task.getId())) {
            this._rootLogger.debug(START_TASK_FORMAT, (Object)this._planId, (Object)task.getName());
        } else if (this._allLogger.isDebugEnabled()) {
            this._allLogger.debug(START_TASK_FORMAT, (Object)this._planId, (Object)task.getName());
        }
    }

    public <T> void logTaskEnd(Task<T> task, Function<T, String> traceValueProvider) {
        if (this._planLogger.isTraceEnabled()) {
            this._planLogger.trace(END_TASK_TRACE_FORMAT, new Object[]{this._planId, task.getName(), this.elapsedMillis(task), ResultType.fromTask(task), this.stringValue(task, traceValueProvider)});
        } else if (this._planLogger.isDebugEnabled()) {
            this._planLogger.debug(END_TASK_DEBUG_FORMAT, new Object[]{this._planId, task.getName(), this.elapsedMillis(task), ResultType.fromTask(task)});
        } else if (this._rootId.equals(task.getId()) && this._rootLogger.isTraceEnabled()) {
            this._rootLogger.trace(END_TASK_TRACE_FORMAT, new Object[]{this._planId, task.getName(), this.elapsedMillis(task), ResultType.fromTask(task), this.stringValue(task, traceValueProvider)});
        } else if (this._rootId.equals(task.getId()) && this._rootLogger.isDebugEnabled()) {
            this._rootLogger.debug(END_TASK_DEBUG_FORMAT, new Object[]{this._planId, task.getName(), this.elapsedMillis(task), ResultType.fromTask(task)});
        } else if (this._allLogger.isTraceEnabled()) {
            this._allLogger.trace(END_TASK_TRACE_FORMAT, new Object[]{this._planId, task.getName(), this.elapsedMillis(task), ResultType.fromTask(task), this.stringValue(task, traceValueProvider)});
        } else if (this._allLogger.isDebugEnabled()) {
            this._allLogger.debug(END_TASK_DEBUG_FORMAT, new Object[]{this._planId, task.getName(), this.elapsedMillis(task), ResultType.fromTask(task)});
        }
    }

    private <T> String stringValue(Task<T> task, Function<T, String> traceValueProvider) {
        if (task.isFailed()) {
            return Exceptions.failureToString(task.getError());
        }
        if (traceValueProvider != null) {
            try {
                return traceValueProvider.apply(task.get());
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        return "null";
    }

    private long elapsedMillis(Task<?> task) {
        ShallowTrace trace = task.getShallowTrace();
        return (trace.getEndNanos() - trace.getStartNanos()) / 1000000L;
    }
}

