/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.retry;

import com.linkedin.parseq.retry.ErrorClassification;
import com.linkedin.parseq.retry.RetryPolicy;
import com.linkedin.parseq.retry.RetryPolicyImpl;
import com.linkedin.parseq.retry.backoff.BackoffPolicy;
import com.linkedin.parseq.retry.termination.TerminationPolicy;
import java.util.function.Function;

public final class RetryPolicyBuilder {
    private final RetryPolicyImpl _retryPolicy = new RetryPolicyImpl();

    public RetryPolicy build() {
        if (this._retryPolicy.getTerminationPolicy() == null) {
            throw new IllegalArgumentException("Unable to build retry policy because termination policy is not specified");
        }
        if (this._retryPolicy.getBackoffPolicy() == null) {
            this._retryPolicy.setBackoffPolicy(BackoffPolicy.noBackoff());
        }
        if (this._retryPolicy.getErrorClassifier() == null) {
            this._retryPolicy.setErrorClassifier(ErrorClassification.DEFAULT);
        }
        if (this._retryPolicy.getName() == null) {
            String backoffPolicyName;
            StringBuilder policyName = new StringBuilder("RetryPolicy");
            String terminationPolicyName = this._retryPolicy.getTerminationPolicy().getClass().getSimpleName();
            if (!terminationPolicyName.contains("$$")) {
                policyName.append(".");
                policyName.append(terminationPolicyName);
            }
            if (!(backoffPolicyName = this._retryPolicy.getBackoffPolicy().getClass().getSimpleName()).contains("$$")) {
                policyName.append(".");
                policyName.append(backoffPolicyName);
            }
            this._retryPolicy.setName(policyName.toString());
        }
        return this._retryPolicy;
    }

    public RetryPolicyBuilder setName(String name) {
        this._retryPolicy.setName(name);
        return this;
    }

    public RetryPolicyBuilder setTerminationPolicy(TerminationPolicy terminationPolicy) {
        this._retryPolicy.setTerminationPolicy(terminationPolicy);
        return this;
    }

    public RetryPolicyBuilder setBackoffPolicy(BackoffPolicy backoffPolicy) {
        this._retryPolicy.setBackoffPolicy(backoffPolicy);
        return this;
    }

    public RetryPolicyBuilder setErrorClassifier(Function<Throwable, ErrorClassification> errorClassifier) {
        this._retryPolicy.setErrorClassifier(errorClassifier);
        return this;
    }
}

