/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeUtil;

public abstract class TableModify
extends SingleRel {
    protected Prepare.CatalogReader catalogReader;
    protected final RelOptTable table;
    private final Operation operation;
    private final List<String> updateColumnList;
    private RelDataType inputRowType;
    private final boolean flattened;

    protected TableModify(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, Operation operation, List<String> updateColumnList, boolean flattened) {
        super(cluster, traits, child);
        this.table = table;
        this.catalogReader = catalogReader;
        this.operation = operation;
        this.updateColumnList = updateColumnList;
        if (table.getRelOptSchema() != null) {
            cluster.getPlanner().registerSchema(table.getRelOptSchema());
        }
        this.flattened = flattened;
    }

    public Prepare.CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    @Override
    public RelOptTable getTable() {
        return this.table;
    }

    public List<String> getUpdateColumnList() {
        return this.updateColumnList;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public boolean isInsert() {
        return this.operation == Operation.INSERT;
    }

    public boolean isUpdate() {
        return this.operation == Operation.UPDATE;
    }

    public boolean isDelete() {
        return this.operation == Operation.DELETE;
    }

    public boolean isMerge() {
        return this.operation == Operation.MERGE;
    }

    @Override
    public RelDataType deriveRowType() {
        return RelOptUtil.createDmlRowType(SqlKind.INSERT, this.getCluster().getTypeFactory());
    }

    @Override
    public RelDataType getExpectedInputRowType(int ordinalInParent) {
        assert (ordinalInParent == 0);
        if (this.inputRowType != null) {
            return this.inputRowType;
        }
        this.inputRowType = this.isUpdate() ? this.getCluster().getTypeFactory().createJoinType(this.table.getRowType(), this.getCatalogReader().createTypeFromProjection(this.table.getRowType(), this.updateColumnList)) : (this.isMerge() ? this.getCluster().getTypeFactory().createJoinType(this.getCluster().getTypeFactory().createJoinType(this.table.getRowType(), this.table.getRowType()), this.getCatalogReader().createTypeFromProjection(this.table.getRowType(), this.updateColumnList)) : this.table.getRowType());
        if (this.flattened) {
            this.inputRowType = SqlTypeUtil.flattenRecordType(this.getCluster().getTypeFactory(), this.inputRowType, null);
        }
        return this.inputRowType;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("table", this.table.getQualifiedName()).item("operation", (Object)this.getOperation()).item("updateColumnList", this.updateColumnList == null ? Collections.EMPTY_LIST : this.updateColumnList).item("flattened", this.flattened);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double rowCount = RelMetadataQuery.getRowCount(this);
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    public static enum Operation {
        INSERT,
        UPDATE,
        DELETE,
        MERGE;

    }
}

