/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.http;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.gobblin.http.ApacheHttpResponseStatus;
import org.apache.gobblin.http.ResponseHandler;
import org.apache.gobblin.http.StatusType;
import org.apache.gobblin.net.Request;
import org.apache.gobblin.utils.HttpUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpResponseHandler<RP extends HttpResponse>
implements ResponseHandler<HttpUriRequest, RP> {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpResponseHandler.class);
    private final Set<String> errorCodeWhitelist;

    public ApacheHttpResponseHandler() {
        this(new HashSet<String>());
    }

    public ApacheHttpResponseHandler(Set<String> errorCodeWhitelist) {
        this.errorCodeWhitelist = errorCodeWhitelist;
    }

    public ApacheHttpResponseStatus handleResponse(Request<HttpUriRequest> request, RP response) {
        ApacheHttpResponseStatus status = new ApacheHttpResponseStatus(StatusType.OK);
        int statusCode = response.getStatusLine().getStatusCode();
        status.setStatusCode(statusCode);
        HttpUtils.updateStatusType(status, statusCode, this.errorCodeWhitelist);
        if (status.getType() == StatusType.OK) {
            status.setContent(this.getEntityAsByteArray(response.getEntity()));
            status.setContentType(response.getEntity().getContentType().getValue());
        } else {
            log.info("Receive an unsuccessful response with status code: " + statusCode);
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            this.consumeEntity(entity);
        }
        return status;
    }

    private byte[] getEntityAsByteArray(HttpEntity entity) {
        try {
            return EntityUtils.toByteArray((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void consumeEntity(HttpEntity entity) {
        try {
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

