/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.r2;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.transport.common.Client;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.http.ThrottledHttpClient;
import org.apache.gobblin.utils.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2Client
extends ThrottledHttpClient<RestRequest, RestResponse> {
    private static final Logger log = LoggerFactory.getLogger(R2Client.class);
    private final Client client;

    public R2Client(Client client, Config config, SharedResourcesBroker broker) {
        super((SharedResourcesBroker<GobblinScopeTypes>)broker, HttpUtils.createR2ClientLimiterKey(config));
        this.client = client;
    }

    @Override
    public RestResponse sendRequestImpl(RestRequest request) throws IOException {
        RestResponse response;
        Future responseFuture = this.client.restRequest(request);
        try {
            response = (RestResponse)responseFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable t = e.getCause();
            if (t != null && t instanceof RestException) {
                response = ((RestException)t).getResponse();
            }
            throw new IOException(e);
        }
        return response;
    }

    @Override
    public void sendAsyncRequestImpl(RestRequest request, final org.apache.gobblin.async.Callback<RestResponse> callback) throws IOException {
        log.debug("Request URI : {} ", (Object)request.getURI());
        this.client.restRequest(request, (Callback)new Callback<RestResponse>(){

            public void onError(Throwable e) {
                callback.onFailure(e);
            }

            public void onSuccess(RestResponse result) {
                callback.onSuccess((Object)result);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.client.shutdown(Callbacks.empty());
    }
}

