/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.r2;

import com.google.common.collect.ImmutableMap;
import com.linkedin.d2.balancer.D2ClientBuilder;
import com.linkedin.r2.transport.common.Client;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.http.client.HttpClientFactory;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.gobblin.r2.D2ClientProxy;
import org.apache.gobblin.r2.R2HttpClientProxy;
import org.apache.gobblin.security.ssl.SSLContextFactory;

public class R2ClientFactory {
    public static final String SSL_ENABLED = "ssl";
    public static final String PROPERTIES = "properties";
    public static final String CLIENT_SERVICES_CONFIG = "clientServicesConfig";
    private static final String ZOOKEEPER_HOSTS = "zkHosts";
    private static final Config FALLBACK = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"ssl", (Object)false).put((Object)"d2.ssl", (Object)false).build());
    private Schema schema;

    public R2ClientFactory(Schema schema) {
        this.schema = schema;
    }

    public Client createInstance(Config srcConfig) {
        Config config = srcConfig.withFallback((ConfigMergeable)FALLBACK);
        switch (this.schema) {
            case HTTP: {
                return this.createHttpClient(config);
            }
            case D2: {
                String confPrefix = this.schema.name().toLowerCase();
                if (config.hasPath(confPrefix)) {
                    Config d2Config = config.getConfig(confPrefix);
                    return this.createD2Client(d2Config);
                }
                throw new ConfigException.Missing(confPrefix);
            }
        }
        throw new RuntimeException("Schema not supported: " + this.schema.name());
    }

    private Client createHttpClient(Config config) {
        boolean isSSLEnabled = config.getBoolean(SSL_ENABLED);
        SSLContext sslContext = null;
        SSLParameters sslParameters = null;
        if (isSSLEnabled) {
            sslContext = SSLContextFactory.createInstance((Config)config);
            sslParameters = sslContext.getDefaultSSLParameters();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("http.sslContext", sslContext);
        properties.put("http.sslParams", sslParameters);
        if (config.hasPath(PROPERTIES)) {
            properties.putAll(R2ClientFactory.toMap(config.getConfig(PROPERTIES)));
        }
        return new R2HttpClientProxy((TransportClientFactory)new HttpClientFactory(), properties);
    }

    private Client createD2Client(Config config) {
        String zkhosts = config.getString(ZOOKEEPER_HOSTS);
        if (zkhosts == null || zkhosts.length() == 0) {
            throw new ConfigException.Missing(ZOOKEEPER_HOSTS);
        }
        D2ClientBuilder d2Builder = new D2ClientBuilder().setZkHosts(zkhosts);
        boolean isSSLEnabled = config.getBoolean(SSL_ENABLED);
        if (isSSLEnabled) {
            d2Builder.setIsSSLEnabled(true);
            SSLContext sslContext = SSLContextFactory.createInstance((Config)config);
            d2Builder.setSSLContext(sslContext);
            d2Builder.setSSLParameters(sslContext.getDefaultSSLParameters());
        }
        if (config.hasPath(CLIENT_SERVICES_CONFIG)) {
            Config clientServiceConfig = config.getConfig(CLIENT_SERVICES_CONFIG);
            HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
            for (String key : clientServiceConfig.root().keySet()) {
                Config value = clientServiceConfig.getConfig(key);
                result.put(key, R2ClientFactory.toMap(value));
            }
            d2Builder.setClientServicesConfig(result);
        }
        return new D2ClientProxy(d2Builder, isSSLEnabled);
    }

    private static Map<String, Object> toMap(Config config) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : config.entrySet()) {
            map.put((String)entry.getKey(), ((ConfigValue)entry.getValue()).unwrapped());
        }
        return map;
    }

    public static enum Schema {
        HTTP,
        D2;

    }
}

