/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.r2;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.rest.RestRequest;
import java.nio.charset.Charset;
import org.apache.gobblin.async.AsyncRequest;

public class R2Request<D>
extends AsyncRequest<D, RestRequest> {
    public String toString() {
        RestRequest request = (RestRequest)this.getRawRequest();
        StringBuilder outBuffer = new StringBuilder();
        String endl = "\n";
        outBuffer.append("R2Request Info").append(endl);
        outBuffer.append("type: RestRequest").append(endl);
        outBuffer.append("uri: ").append(request.getURI().toString()).append(endl);
        outBuffer.append("headers: ");
        request.getHeaders().forEach((k, v) -> outBuffer.append("[").append((String)k).append(":").append((String)v).append("] "));
        outBuffer.append(endl);
        ByteString entity = request.getEntity();
        if (entity != null) {
            outBuffer.append("body: ").append(entity.asString(Charset.defaultCharset())).append(endl);
        }
        return outBuffer.toString();
    }
}

