/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.io.IOException;
import java.util.Queue;
import org.apache.gobblin.async.AsyncRequest;
import org.apache.gobblin.async.AsyncRequestBuilder;
import org.apache.gobblin.async.BufferedRecord;
import org.apache.gobblin.async.DispatchException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.http.HttpClient;
import org.apache.gobblin.http.ResponseHandler;
import org.apache.gobblin.http.ResponseStatus;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.FailureEventBuilder;
import org.apache.gobblin.net.Request;
import org.apache.gobblin.writer.AbstractAsyncDataWriter;
import org.apache.gobblin.writer.AsyncHttpWriterBuilder;
import org.apache.gobblin.writer.WriteCallback;
import org.apache.gobblin.writer.WriteResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpWriter<D, RQ, RP>
extends AbstractAsyncDataWriter<D> {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpWriter.class);
    private static final Logger LOG = LoggerFactory.getLogger(AsyncHttpWriter.class);
    private static final String ASYNC_REQUEST = "asyncRequest";
    private static final String FATAL_ASYNC_HTTP_WRITE_EVENT = "fatalAsyncHttpWrite";
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    private final HttpClient<RQ, RP> httpClient;
    private final ResponseHandler<RQ, RP> responseHandler;
    private final AsyncRequestBuilder<D, RQ> requestBuilder;
    private final int maxAttempts;
    private final MetricContext context;

    public AsyncHttpWriter(AsyncHttpWriterBuilder builder) {
        super(builder.getQueueCapacity());
        this.httpClient = builder.getClient();
        this.requestBuilder = builder.getAsyncRequestBuilder();
        this.responseHandler = builder.getResponseHandler();
        this.maxAttempts = builder.getMaxAttempts();
        this.context = Instrumented.getMetricContext((State)builder.getState(), AsyncHttpWriter.class);
    }

    protected void dispatch(Queue<BufferedRecord<D>> buffer) throws DispatchException {
        AsyncRequest asyncRequest = this.requestBuilder.buildRequest(buffer);
        if (asyncRequest == null) {
            return;
        }
        Object rawRequest = asyncRequest.getRawRequest();
        int attempt = 0;
        while (attempt < this.maxAttempts) {
            RP response;
            try {
                response = this.httpClient.sendRequest(rawRequest);
            }
            catch (IOException e) {
                if (++attempt != this.maxAttempts) continue;
                LOG.error("Fail to send request");
                LOG.info(asyncRequest.toString());
                DispatchException de = new DispatchException("Write failed on IOException", (Exception)e);
                this.onFailure(asyncRequest, de);
                throw de;
            }
            ResponseStatus status = this.responseHandler.handleResponse((Request<RQ>)asyncRequest, response);
            switch (status.getType()) {
                case OK: {
                    this.onSuccess(asyncRequest, status);
                    return;
                }
                case CONTINUE: {
                    LOG.debug("Http write continues");
                    LOG.debug(asyncRequest.toString());
                    this.onSuccess(asyncRequest, status);
                    return;
                }
                case CLIENT_ERROR: {
                    LOG.error("Http write failed on client error");
                    LOG.info(asyncRequest.toString());
                    DispatchException clientExp = new DispatchException("Write failed on client error");
                    this.onFailure(asyncRequest, clientExp);
                    throw clientExp;
                }
                case SERVER_ERROR: {
                    if (++attempt != this.maxAttempts) break;
                    LOG.error("Http write request failed on server error");
                    LOG.info(asyncRequest.toString());
                    DispatchException serverExp = new DispatchException("Write failed after " + this.maxAttempts + " attempts.");
                    this.onFailure(asyncRequest, serverExp);
                    throw serverExp;
                }
            }
        }
    }

    protected void onSuccess(AsyncRequest<D, RQ> asyncRequest, ResponseStatus status) {
        final WriteResponse response = WriteResponse.EMPTY;
        for (final AsyncRequest.Thunk thunk : asyncRequest.getThunks()) {
            WriteCallback callback = (WriteCallback)thunk.callback;
            callback.onSuccess((Object)new WriteResponse(){

                public Object getRawResponse() {
                    return response.getRawResponse();
                }

                public String getStringResponse() {
                    return response.getStringResponse();
                }

                public long bytesWritten() {
                    return thunk.sizeInBytes;
                }
            });
        }
    }

    @Deprecated
    protected void onFailure(AsyncRequest<D, RQ> asyncRequest, Throwable throwable) {
        for (AsyncRequest.Thunk thunk : asyncRequest.getThunks()) {
            thunk.callback.onFailure(throwable);
        }
    }

    protected void onFailure(AsyncRequest<D, RQ> asyncRequest, DispatchException exception) {
        if (exception.isFatal()) {
            FailureEventBuilder failureEvent = new FailureEventBuilder(FATAL_ASYNC_HTTP_WRITE_EVENT);
            failureEvent.setRootCause((Throwable)exception);
            failureEvent.addMetadata(ASYNC_REQUEST, asyncRequest.toString());
            failureEvent.submit(this.context);
        }
        for (AsyncRequest.Thunk thunk : asyncRequest.getThunks()) {
            thunk.callback.onFailure((Throwable)exception);
        }
    }

    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.httpClient.close();
        }
    }
}

