/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.Map;
import java.util.Set;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.http.ApacheHttpClient;
import org.apache.gobblin.http.ApacheHttpRequestBuilder;
import org.apache.gobblin.http.ApacheHttpResponseHandler;
import org.apache.gobblin.utils.HttpUtils;
import org.apache.gobblin.writer.AsyncHttpWriterBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroHttpWriterBuilder
extends AsyncHttpWriterBuilder<GenericRecord, HttpUriRequest, CloseableHttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(AvroHttpWriterBuilder.class);
    private static final Config FALLBACK = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"contentType", (Object)"application/json").build());

    public AvroHttpWriterBuilder fromConfig(Config config) {
        config = config.withFallback((ConfigMergeable)FALLBACK);
        ApacheHttpClient client = new ApacheHttpClient(HttpClientBuilder.create(), config, (SharedResourcesBroker<GobblinScopeTypes>)this.broker);
        this.client = client;
        String urlTemplate = config.getString("urlTemplate");
        String verb = config.getString("verb");
        String contentType = config.getString("contentType");
        this.asyncRequestBuilder = new ApacheHttpRequestBuilder(urlTemplate, verb, contentType);
        Set<String> errorCodeWhitelist = HttpUtils.getErrorCodeWhitelist(config);
        this.responseHandler = new ApacheHttpResponseHandler(errorCodeWhitelist);
        return this;
    }
}

