/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import retrofit.ErrorHandler;
import retrofit.RetrofitError;
import retrofit.client.Response;

class InfluxDBErrorHandler
implements ErrorHandler {
    InfluxDBErrorHandler() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Throwable handleError(RetrofitError cause) {
        Response r = cause.getResponse();
        if (r == null) return cause;
        if (r.getStatus() < 400) return cause;
        try (InputStreamReader reader = new InputStreamReader(r.getBody().in(), Charsets.UTF_8);){
            RuntimeException runtimeException = new RuntimeException(CharStreams.toString((Readable)reader));
            return runtimeException;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cause;
    }
}

