/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore;

import com.google.common.base.Predicate;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.metadata.StateStoreEntryManager;
import org.apache.gobblin.metastore.predicates.StateStorePredicate;

public interface StateStore<T extends State> {
    public boolean create(String var1) throws IOException;

    public boolean create(String var1, String var2) throws IOException;

    public boolean exists(String var1, String var2) throws IOException;

    public void put(String var1, String var2, T var3) throws IOException;

    public void putAll(String var1, String var2, Collection<T> var3) throws IOException;

    public T get(String var1, String var2, String var3) throws IOException;

    public List<T> getAll(String var1, String var2) throws IOException;

    public List<T> getAll(String var1) throws IOException;

    public List<String> getTableNames(String var1, Predicate<String> var2) throws IOException;

    public void createAlias(String var1, String var2, String var3) throws IOException;

    public void delete(String var1, String var2) throws IOException;

    public void delete(String var1) throws IOException;

    default public List<? extends StateStoreEntryManager> getMetadataForTables(StateStorePredicate predicate) throws IOException {
        throw new UnsupportedOperationException("Operation unsupported for predicate with class " + predicate.getClass());
    }

    public static interface Factory {
        public <T extends State> StateStore<T> createStateStore(Config var1, Class<T> var2);
    }
}

