/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore.database;

import com.google.common.base.Preconditions;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

class Filter {
    public static final Filter MISSING = new Filter();
    private final String filter;
    private final List<String> values;

    private Filter() {
        this.filter = null;
        this.values = null;
    }

    public Filter(String filter, List<String> values) {
        Preconditions.checkNotNull((Object)filter);
        Preconditions.checkNotNull(values);
        this.filter = filter;
        this.values = values;
    }

    public String toString() {
        return this.filter;
    }

    public int addParameters(PreparedStatement statement, int index) throws SQLException {
        if (this.values != null) {
            for (String value : this.values) {
                statement.setString(index++, value);
            }
        }
        return index;
    }

    public boolean isPresent() {
        return this != MISSING;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filter = this.getFilter();
        String other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        List<String> this$values = this.getValues();
        List<String> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Filter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        List<String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String getFilter() {
        return this.filter;
    }

    public List<String> getValues() {
        return this.values;
    }
}

