/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore.predicates;

import com.google.common.base.Predicate;
import java.io.IOException;
import org.apache.gobblin.metastore.metadata.DatasetStateStoreEntryManager;
import org.apache.gobblin.metastore.metadata.StateStoreEntryManager;
import org.apache.gobblin.metastore.predicates.StoreNamePredicate;

public class DatasetPredicate
extends StoreNamePredicate {
    private final String datasetUrn;

    public DatasetPredicate(String storeName, String datasetUrn, Predicate<StateStoreEntryManager> customPredicate) {
        super(storeName, customPredicate);
        this.datasetUrn = datasetUrn;
    }

    @Override
    public boolean apply(StateStoreEntryManager input) {
        if (!(input instanceof DatasetStateStoreEntryManager)) {
            return false;
        }
        DatasetStateStoreEntryManager datasetStateStoreEntryMetadata = (DatasetStateStoreEntryManager)input;
        try {
            return super.apply(input) && datasetStateStoreEntryMetadata.getStateStore().sanitizeDatasetStatestoreNameFromDatasetURN(this.getStoreName(), this.datasetUrn).equals(((DatasetStateStoreEntryManager)input).getSanitizedDatasetUrn());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

