/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.util.ConfigUtils;

public class FlattenNestedKeyConverter
extends Converter<Schema, Schema, GenericRecord, GenericRecord> {
    public static final String FIELDS_TO_FLATTEN = "fieldsToFlatten";
    private Map<String, String> fieldNameMap = Maps.newHashMap();

    public Schema convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        this.fieldNameMap.clear();
        Config config = ConfigUtils.propertiesToConfig((Properties)workUnit.getProperties()).getConfig(((Object)((Object)this)).getClass().getSimpleName());
        List nestedKeys = ConfigUtils.getStringList((Config)config, (String)FIELDS_TO_FLATTEN);
        if (nestedKeys == null || nestedKeys.size() == 0) {
            return inputSchema;
        }
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (Schema.Field field : inputSchema.getFields()) {
            fields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue(), field.order()));
        }
        for (String key : nestedKeys) {
            String nestedKey;
            String hyphenizedKey;
            String name;
            if (!key.contains(".") || this.fieldNameMap.containsKey(name = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, hyphenizedKey = (nestedKey = key.trim()).replace(".", "-")))) continue;
            this.fieldNameMap.put(name, nestedKey);
            Optional optional = AvroUtils.getField((Schema)inputSchema, (String)nestedKey);
            if (!optional.isPresent()) {
                throw new SchemaConversionException("Unable to get field with location: " + nestedKey);
            }
            Schema.Field field = (Schema.Field)optional.get();
            Schema.Field copy = new Schema.Field(name, field.schema(), field.doc(), field.defaultValue(), field.order());
            fields.add(copy);
        }
        Schema outputSchema = Schema.createRecord((String)inputSchema.getName(), (String)inputSchema.getDoc(), (String)inputSchema.getNamespace(), (boolean)inputSchema.isError());
        outputSchema.setFields(fields);
        return outputSchema;
    }

    public Iterable<GenericRecord> convertRecord(Schema outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        if (this.fieldNameMap.size() == 0) {
            return new SingleRecordIterable((Object)inputRecord);
        }
        GenericData.Record outputRecord = new GenericData.Record(outputSchema);
        for (Schema.Field field : outputSchema.getFields()) {
            String fieldName = field.name();
            if (this.fieldNameMap.containsKey(fieldName)) continue;
            outputRecord.put(fieldName, inputRecord.get(fieldName));
        }
        for (Map.Entry entry : this.fieldNameMap.entrySet()) {
            Optional optional = AvroUtils.getFieldValue((GenericRecord)inputRecord, (String)((String)entry.getValue()));
            if (!optional.isPresent()) {
                throw new DataConversionException("Unable to get field value with location: " + (String)entry.getValue());
            }
            outputRecord.put((String)entry.getKey(), optional.get());
        }
        return new SingleRecordIterable((Object)outputRecord);
    }
}

