/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.string;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.util.ForkOperatorUtils;

public class StringSplitterConverter
extends Converter<Class<String>, Class<String>, String, String> {
    private Splitter splitter;

    public Converter<Class<String>, Class<String>, String, String> init(WorkUnitState workUnit) {
        String stringSplitterDelimiterKey = ForkOperatorUtils.getPropertyNameForBranch((WorkUnitState)workUnit, (String)"converter.string.splitter.delimiter");
        Preconditions.checkArgument((boolean)workUnit.contains(stringSplitterDelimiterKey), (Object)("Cannot use " + ((Object)((Object)this)).getClass().getName() + " with out specifying " + "converter.string.splitter.delimiter"));
        this.splitter = Splitter.on((String)workUnit.getProp(stringSplitterDelimiterKey)).omitEmptyStrings();
        return this;
    }

    public Class<String> convertSchema(Class<String> inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return inputSchema;
    }

    public Iterable<String> convertRecord(Class<String> outputSchema, String inputRecord, WorkUnitState workUnit) throws DataConversionException {
        return this.splitter.split((CharSequence)inputRecord);
    }
}

