/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.http.HttpClientConfigurator;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

@Alias(value="default")
public class DefaultHttpClientConfigurator
implements HttpClientConfigurator {
    public static final String PROXY_URL_KEY = "use.proxy.url";
    public static final String PROXY_PORT_KEY = "use.proxy.port";
    public static final String PROXY_HOSTPORT_KEY = "proxyHostport";
    public static final int DEFAULT_HTTP_PROXY_PORT = 8080;
    private static final Pattern HOSTPORT_PATTERN = Pattern.compile("([^:]+)(:([0-9]+))?");
    protected final HttpClientBuilder _builder = HttpClientBuilder.create();
    protected String _statePropertiesPrefix = null;

    @Override
    public DefaultHttpClientConfigurator configure(Config httpClientConfig) {
        Optional<HttpHost> proxy = DefaultHttpClientConfigurator.getProxyAddr(httpClientConfig);
        if (proxy.isPresent()) {
            this.getBuilder().setProxy((HttpHost)proxy.get());
        }
        return this;
    }

    @Override
    public DefaultHttpClientConfigurator configure(State state) {
        Config cfg = this.stateToConfig(state);
        return this.configure(cfg);
    }

    protected Config stateToConfig(State state) {
        String proxyUrlKey = this.getPrefixedPropertyName(PROXY_URL_KEY);
        String proxyPortKey = this.getPrefixedPropertyName(PROXY_PORT_KEY);
        String proxyHostportKey = this.getPrefixedPropertyName(PROXY_HOSTPORT_KEY);
        Config cfg = ConfigFactory.empty();
        if (state.contains(proxyUrlKey)) {
            cfg = cfg.withValue(PROXY_URL_KEY, ConfigValueFactory.fromAnyRef((Object)state.getProp(proxyUrlKey)));
        }
        if (state.contains(proxyPortKey)) {
            cfg = cfg.withValue(PROXY_PORT_KEY, ConfigValueFactory.fromAnyRef((Object)state.getPropAsInt(proxyPortKey)));
        }
        if (state.contains(proxyHostportKey)) {
            cfg = cfg.withValue(PROXY_HOSTPORT_KEY, ConfigValueFactory.fromAnyRef((Object)state.getProp(proxyHostportKey)));
        }
        return cfg;
    }

    public CloseableHttpClient createClient() {
        return this._builder.build();
    }

    @VisibleForTesting
    public static Optional<HttpHost> getProxyAddr(Config httpClientConfig) {
        String proxyHost = null;
        int proxyPort = 8080;
        if (httpClientConfig.hasPath(PROXY_URL_KEY) && !httpClientConfig.getString(PROXY_URL_KEY).isEmpty()) {
            proxyHost = httpClientConfig.getString(PROXY_URL_KEY);
        }
        if (httpClientConfig.hasPath(PROXY_PORT_KEY)) {
            proxyPort = httpClientConfig.getInt(PROXY_PORT_KEY);
        }
        if (httpClientConfig.hasPath(PROXY_HOSTPORT_KEY)) {
            String hostport = httpClientConfig.getString(PROXY_HOSTPORT_KEY);
            Matcher hostportMatcher = HOSTPORT_PATTERN.matcher(hostport);
            if (!hostportMatcher.matches()) {
                throw new IllegalArgumentException("Invalid HTTP proxy hostport: " + hostport);
            }
            proxyHost = hostportMatcher.group(1);
            if (!Strings.isNullOrEmpty((String)hostportMatcher.group(3))) {
                proxyPort = Integer.parseInt(hostportMatcher.group(3));
            }
        }
        return null != proxyHost ? Optional.of((Object)new HttpHost(proxyHost, proxyPort)) : Optional.absent();
    }

    @Override
    public DefaultHttpClientConfigurator setStatePropertiesPrefix(String propertiesPrefix) {
        this._statePropertiesPrefix = propertiesPrefix;
        return this;
    }

    String getPrefixedPropertyName(String propertyName) {
        return null != this._statePropertiesPrefix ? this._statePropertiesPrefix + propertyName : propertyName;
    }

    @Override
    public HttpClientBuilder getBuilder() {
        return this._builder;
    }
}

