/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.http;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.http.DefaultHttpClientConfigurator;
import org.apache.gobblin.http.HttpClientConfigurator;
import org.apache.gobblin.util.ClassAliasResolver;

public class HttpClientConfiguratorLoader {
    public static final String HTTP_CLIENT_CONFIGURATOR_TYPE_KEY = "httpClientConfigurator.type";
    public static final String HTTP_CLIENT_CONFIGURATOR_TYPE_FULL_KEY = "gobblin.httpClientConfigurator.type";
    public static final Class<? extends HttpClientConfigurator> DEFAULT_CONFIGURATOR_CLASS = DefaultHttpClientConfigurator.class;
    private static final ClassAliasResolver<HttpClientConfigurator> TYPE_RESOLVER = new ClassAliasResolver(HttpClientConfigurator.class);
    private final HttpClientConfigurator _configurator;

    public HttpClientConfiguratorLoader(State state) {
        this((Optional<String>)Optional.fromNullable((Object)state.getProp(HTTP_CLIENT_CONFIGURATOR_TYPE_FULL_KEY)));
    }

    public HttpClientConfiguratorLoader(Config config) {
        this((Optional<String>)Optional.fromNullable(config.hasPath(HTTP_CLIENT_CONFIGURATOR_TYPE_KEY) ? config.getString(HTTP_CLIENT_CONFIGURATOR_TYPE_KEY) : null));
    }

    public HttpClientConfiguratorLoader(Optional<String> configuratorType) {
        try {
            this._configurator = HttpClientConfiguratorLoader.getConfiguratorClass(configuratorType).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to find HttpClientConfigurator:" + e, e);
        }
    }

    private static Class<? extends HttpClientConfigurator> getConfiguratorClass(Optional<String> configuratorType) throws ClassNotFoundException {
        return configuratorType.isPresent() ? TYPE_RESOLVER.resolveClass((String)configuratorType.get()) : DEFAULT_CONFIGURATOR_CLASS;
    }

    public HttpClientConfigurator getConfigurator() {
        return this._configurator;
    }
}

