/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.PartitionAwareFileRetriever;
import org.apache.gobblin.source.PartitionAwareFileRetrieverUtils;
import org.apache.gobblin.source.PartitionedFileSourceBase;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelperException;
import org.apache.gobblin.source.extractor.hadoop.HadoopFsHelper;
import org.apache.gobblin.util.DatePartitionType;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatePartitionedNestedRetriever
implements PartitionAwareFileRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(DatePartitionedNestedRetriever.class);
    private DateTimeFormatter partitionPatternFormatter;
    private DurationFieldType incrementalUnit;
    private String sourcePartitionPrefix;
    private String sourcePartitionSuffix;
    private Path sourceDir;
    private FileSystem fs;
    private HadoopFsHelper helper;
    private final String expectedExtension;
    private Duration leadTimeDuration;
    private boolean schemaInSourceDir;
    private String schemaFile;

    public DatePartitionedNestedRetriever(String expectedExtension) {
        this.expectedExtension = expectedExtension;
    }

    @Override
    public void init(SourceState state) {
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forID((String)state.getProp("source.timezone", "America/Los_Angeles")));
        this.initDatePartition((State)state);
        this.sourcePartitionPrefix = state.getProp("date.partitioned.source.partition.prefix", "");
        this.sourcePartitionSuffix = state.getProp("date.partitioned.source.partition.suffix", "");
        this.sourceDir = new Path(state.getProp("source.filebased.data.directory"));
        this.leadTimeDuration = PartitionAwareFileRetrieverUtils.getLeadTimeDurationFromConfig((State)state);
        this.helper = new HadoopFsHelper((State)state);
        this.schemaInSourceDir = state.getPropAsBoolean("schema.in.source.dir", false);
        this.schemaFile = this.schemaInSourceDir ? state.getProp("schema.filename", "metadata.json") : "";
    }

    @Override
    public List<PartitionAwareFileRetriever.FileInfo> getFilesToProcess(long minWatermark, int maxFilesToReturn) throws IOException {
        DateTime currentDay = new DateTime().minus((ReadableDuration)this.leadTimeDuration);
        DateTime lowWaterMarkDate = new DateTime(minWatermark);
        ArrayList<PartitionAwareFileRetriever.FileInfo> filesToProcess = new ArrayList<PartitionAwareFileRetriever.FileInfo>();
        try {
            this.helper.connect();
            this.fs = this.helper.getFileSystem();
        }
        catch (FileBasedHelperException e) {
            throw new IOException("Error initializing FileSystem", e);
        }
        DateTime date = lowWaterMarkDate;
        while (!date.isAfter((ReadableInstant)currentDay) && filesToProcess.size() < maxFilesToReturn) {
            Path sourcePath = this.constructSourcePath(date);
            if (this.fs.exists(sourcePath)) {
                for (FileStatus fileStatus : this.fs.listStatus(sourcePath, this.getFileFilter())) {
                    LOG.info("Will process file " + fileStatus.getPath());
                    filesToProcess.add(new PartitionAwareFileRetriever.FileInfo(fileStatus.getPath().toString(), fileStatus.getLen(), date.getMillis()));
                }
            }
            date = date.withFieldAdded(this.incrementalUnit, 1);
        }
        return filesToProcess;
    }

    @Override
    public long getWatermarkFromString(String lowWaterMark) {
        return this.partitionPatternFormatter.parseMillis(lowWaterMark);
    }

    @Override
    public long getWatermarkIncrementMs() {
        return new DateTime(0L).withFieldAdded(this.incrementalUnit, 1).getMillis();
    }

    private void initDatePartition(State state) {
        this.initDatePartitionFromPattern(state);
        if (this.partitionPatternFormatter == null) {
            this.initDatePartitionFromGranularity(state);
        }
    }

    private void initDatePartitionFromPattern(State state) {
        String partitionPattern = null;
        try {
            partitionPattern = state.getProp("date.partitioned.source.partition.pattern");
            if (partitionPattern != null) {
                this.partitionPatternFormatter = DateTimeFormat.forPattern((String)partitionPattern).withZone(DateTimeZone.getDefault());
                this.incrementalUnit = DatePartitionType.getLowestIntervalUnit((String)partitionPattern).getDurationType();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid source partition pattern: " + partitionPattern, e);
        }
    }

    private void initDatePartitionFromGranularity(State state) {
        String granularityProp = state.getProp("date.partitioned.source.partition.granularity");
        DatePartitionType partitionType = null;
        if (granularityProp == null) {
            partitionType = PartitionedFileSourceBase.DEFAULT_DATE_PARTITIONED_SOURCE_PARTITION_GRANULARITY;
        } else {
            Optional partitionTypeOpt = Enums.getIfPresent(DatePartitionType.class, (String)granularityProp.toUpperCase());
            Preconditions.checkState((boolean)partitionTypeOpt.isPresent(), (Object)("Invalid source partition granularity: " + granularityProp));
            partitionType = (DatePartitionType)partitionTypeOpt.get();
        }
        this.partitionPatternFormatter = DateTimeFormat.forPattern((String)partitionType.getDateTimePattern());
        this.incrementalUnit = partitionType.getDateTimeFieldType().getDurationType();
    }

    private Path constructSourcePath(DateTime date) {
        StringBuilder pathBuilder = new StringBuilder();
        if (!this.sourcePartitionPrefix.isEmpty()) {
            pathBuilder.append(this.sourcePartitionPrefix);
            pathBuilder.append("/");
        }
        pathBuilder.append(this.partitionPatternFormatter.print((ReadableInstant)date));
        if (!this.sourcePartitionSuffix.isEmpty()) {
            pathBuilder.append("/");
            pathBuilder.append(this.sourcePartitionSuffix);
        }
        return new Path(this.sourceDir, pathBuilder.toString());
    }

    private PathFilter getFileFilter() {
        final String extension = this.expectedExtension.startsWith(".") ? this.expectedExtension : "." + this.expectedExtension;
        return new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().endsWith(extension) && (!DatePartitionedNestedRetriever.this.schemaInSourceDir || !path.getName().equals(DatePartitionedNestedRetriever.this.schemaFile));
            }
        };
    }
}

