/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source;

import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.PartitionedFileSourceBase;
import org.apache.gobblin.util.DatePartitionType;
import org.joda.time.Duration;

public class PartitionAwareFileRetrieverUtils {
    public static Duration getLeadTimeDurationFromConfig(State state) {
        String leadTimeProp = state.getProp("date.partitioned.source.partition.lead_time.size");
        if (leadTimeProp == null || leadTimeProp.length() == 0) {
            return PartitionedFileSourceBase.DEFAULT_PARTITIONED_SOURCE_PARTITION_LEAD_TIME;
        }
        int leadTime = Integer.parseInt(leadTimeProp);
        DatePartitionType leadTimeGranularity = PartitionedFileSourceBase.DEFAULT_DATE_PARTITIONED_SOURCE_PARTITION_LEAD_TIME_GRANULARITY;
        String leadTimeGranularityProp = state.getProp("date.partitioned.source.partition.lead_time.granularity");
        if (leadTimeGranularityProp != null) {
            leadTimeGranularity = DatePartitionType.valueOf((String)leadTimeGranularityProp);
        }
        return new Duration((long)leadTime * leadTimeGranularity.getUnitMilliseconds());
    }
}

